<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:filter="Filter" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:n2="urn:hl7-org:v2xml"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:saxon="http://saxon.sf.net/"
	exclude-result-prefixes="fn n2 xs xsi xsl saxon">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" />
	<xsl:param name="global.hl7Support"/>
	<xsl:template match="/n2:SPQ_Q08">
		<filter:filter vhimVersion="Vhim_4_00">
			<filterId>ALLERGY_SINGLE_PATIENT_ALL_DATA_FILTER</filterId>
			<patients>
				<xsl:variable
					name="Vvar64_Custom_SPR_ST_7_string" as="xs:string"
					select="xs:string(n2:SPR/n2:SPR.4/n2:QIP.2/n2:Custom_SPR_ST.7)" />
				<NationalId>
					<xsl:sequence
						select="substring-after($Vvar64_Custom_SPR_ST_7_string,';')" />
				</NationalId>
				<xsl:if test="saxon:request-whatcode($global.hl7Support) = 'OC_AL'">
                <excludeIdentifiers>
                    <assigningAuthority>USVHA</assigningAuthority>
                    <assigningFacility><xsl:value-of select="xs:string(n2:MSH/n2:MSH.4)"/></assigningFacility>
                </excludeIdentifiers>
                </xsl:if>
			</patients>
			<entryPointFilter queryName="ALLERGY_AA_QUERY">
            	<domainEntryPoint>AllergyAssessment</domainEntryPoint>
            	<xsl:variable name="rawStartDate" select="xs:string(n2:SPR/n2:SPR.4/n2:QIP.2/n2:Custom_SPR_ST.12)"/>
            	<xsl:if test="string-length($rawStartDate) = 15">
                <startDate>
					<xsl:call-template name="formatFilterDate">
						<xsl:with-param name="unformattedDate" select="$rawStartDate"/>
					</xsl:call-template>
				</startDate>
				</xsl:if>
				<xsl:variable name="rawStopDate" select="xs:string(n2:SPR/n2:SPR.4/n2:QIP.2/n2:Custom_SPR_ST.13)"/>
            	<xsl:if test="string-length($rawStopDate) = 15">
				<endDate>
					<xsl:call-template name="formatFilterDate">
						<xsl:with-param name="unformattedDate" select="$rawStopDate"/>
					</xsl:call-template>
				</endDate>
				</xsl:if>
            </entryPointFilter>
			<entryPointFilter queryName="ALLERGY_IC_QUERY">
				<domainEntryPoint>IntoleranceCondition</domainEntryPoint>
				<xsl:variable name="rawStartDate" select="xs:string(n2:SPR/n2:SPR.4/n2:QIP.2/n2:Custom_SPR_ST.12)"/>
            	<xsl:if test="string-length($rawStartDate) = 15">
                <startDate>
					<xsl:call-template name="formatFilterDate">
						<xsl:with-param name="unformattedDate" select="$rawStartDate"/>
					</xsl:call-template>
				</startDate>
				</xsl:if>
				<xsl:variable name="rawStopDate" select="xs:string(n2:SPR/n2:SPR.4/n2:QIP.2/n2:Custom_SPR_ST.13)"/>
            	<xsl:if test="string-length($rawStopDate) = 15">
				<endDate>
					<xsl:call-template name="formatFilterDate">
						<xsl:with-param name="unformattedDate" select="$rawStopDate"/>
					</xsl:call-template>
				</endDate>
				</xsl:if>
			</entryPointFilter>
		</filter:filter>
	</xsl:template>

	<xsl:template name="formatFilterDate">
		<xsl:param name="unformattedDate"/>
		<xsl:variable name="tempYearMonthDate"
			as="xs:string"
			select="substring($unformattedDate,9)" />
		<xsl:variable name="tempYear"
			as="xs:double"
			select="number(substring($tempYearMonthDate,1,3))" />
		<xsl:variable name="tempYearAsInt"
			as="xs:string">
			<xsl:value-of
				select="$tempYear + 1700" />
		</xsl:variable>
		<xsl:variable name="tempMonth"
			as="xs:string" select="substring($tempYearMonthDate,4,2)" />
		<xsl:variable name="tempDay"
			as="xs:string" select="substring($tempYearMonthDate,6,2)" />
		<xsl:sequence
			select="concat($tempYearAsInt,'-',$tempMonth,'-',$tempDay)" />
	</xsl:template>
</xsl:stylesheet>
