<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="urn:hl7-org:v2xml" exclude-result-prefixes="xs fn ns0" xmlns:saxon="http://saxon.sf.net/" xmlns:hthsurvey="HTHSurvey">
	<!--
		##################################################################################################################
		########################################## HL7 COMMON TEMPLATES ###############################################
	-->
	<xsl:template name="getName">
		<name>
			<xsl:if test="(given != '')">
				<given>
					<xsl:sequence select="fn:string(given)"/>
				</given>
			</xsl:if>
			<xsl:if test="(middle != '')">
				<middle>
					<xsl:sequence select="fn:string(middle)"/>
				</middle>
			</xsl:if>
			<xsl:if test="(family != '')">
				<family>
					<xsl:sequence select="fn:string(family)"/>
				</family>
			</xsl:if>
		</name>
	</xsl:template>
	
	<xsl:template name="getSurveyPatient">
		<icn>
			<xsl:sequence select="fn:string(icn)"/>
		</icn>
		<ssn>
			<xsl:sequence select="fn:string(ssn)"/>
		</ssn>
		<xsl:for-each select="name">
			<xsl:call-template name="getName"/>
		</xsl:for-each>
		<birthdate>
			<xsl:sequence select="xs:string(xs:date(fn:string(birthdate)))"/>
		</birthdate>
	</xsl:template>
	
	<xsl:template name="getSurveyCommon">
		<xsl:for-each select="enrollmentDate">
			<enrollmentDate>
				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
			</enrollmentDate>
		</xsl:for-each>
		<xsl:if test="(disenrollmentDate != '')">
			<xsl:for-each select="disenrollmentDate">
				<disenrollmentDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</disenrollmentDate>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="(activationDate != '')">
			<xsl:for-each select="activationDate">
				<activationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</activationDate>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="(inactivationDate != '')">
			<xsl:for-each select="inactivationDate">
				<inactivationDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</inactivationDate>
			</xsl:for-each>
		</xsl:if>
		<vendorMRN>
			<xsl:sequence select="fn:string(vendorMRN)"/>
		</vendorMRN>
		<facility>
			<facilityNumber>
				<xsl:sequence select="fn:string(facilityNumber)"/>
			</facilityNumber>
		</facility>
		<vendor>
			<vendorNumber>
				<xsl:sequence select="fn:string(vendorNumber)"/>
			</vendorNumber>
			<vendorName>
				<xsl:sequence select="fn:string(vendorName)"/>
			</vendorName>
		</vendor>
		<careCoordinator>
			<xsl:for-each select="careCoordinator">
				<id>
					<xsl:sequence select="fn:string(id)"/>
				</id>
				<xsl:for-each select="name">
					<xsl:call-template name="getName"/>
				</xsl:for-each>
			</xsl:for-each>
		</careCoordinator>
		<xsl:if test="(scheduledDate != '')">
			<xsl:for-each select="scheduledDate">
				<scheduledDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</scheduledDate>
			</xsl:for-each>
		</xsl:if>
		<completedDate>
			<xsl:sequence select="xs:string(xs:dateTime(fn:string(completedDate)))"/>
		</completedDate>
		<xsl:for-each select="currentDialogueName">
			<currentDialogueName>
				<xsl:sequence select="fn:string(.)"/>
			</currentDialogueName>
		</xsl:for-each>
		<xsl:for-each select="programName">
			<programName>
				<xsl:sequence select="fn:string(.)"/>
			</programName>
		</xsl:for-each>
		<xsl:for-each select="deviceName">
			<deviceName>
				<xsl:sequence select="fn:string(.)"/>
			</deviceName>
		</xsl:for-each>
		<xsl:for-each select="surveyAcceptedStatus">
			<surveyAcceptedStatus>
				<xsl:sequence select="fn:string(.)"/>
			</surveyAcceptedStatus>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="getSurveyType">
		<survey>
			<surveyTitle>
				<xsl:sequence select="fn:string(surveyTitle)"/>
			</surveyTitle>
			<surveyVersion>
				<xsl:sequence select="fn:string(surveyVersion)"/>
			</surveyVersion>
		</survey>
	</xsl:template>
	
	<xsl:template name="getSurveyQuestionsAndAnswers">
		<surveyQuestionsAndAnswers>
			<xsl:for-each select="surveyQuestionsAndAnswers/surveyQuestionAndAnswer">
				<surveyQuestionAndAnswer>
					<questionNumber>
						<xsl:sequence select="xs:string(xs:integer(fn:string(questionNumber)))"/>
					</questionNumber>
					<answer>
						<xsl:sequence select="xs:string(xs:integer(fn:string(answer)))"/>
					</answer>
				</surveyQuestionAndAnswer>
			</xsl:for-each>
		</surveyQuestionsAndAnswers>
	</xsl:template>
	
	<xsl:template name="getSurveyScores">
		<surveyScores>
			<xsl:for-each select="surveyScores/mentalScore">
				<mentalScore>
					<xsl:sequence select="xs:string(xs:decimal(fn:string(.)))"/>
				</mentalScore>
			</xsl:for-each>
			<xsl:for-each select="surveyScores/physicalScore">
				<physicalScore>
					<xsl:sequence select="xs:string(xs:decimal(fn:string(.)))"/>
				</physicalScore>
			</xsl:for-each>
		</surveyScores>
	</xsl:template>
</xsl:stylesheet>
