package gov.va.med.cds.mediator.xml.transform.saxonextensions;

import gov.va.med.cds.hapi.HL7SupportInterface;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;


public class Hl7SupportMessageDataExtFunc extends ExtensionFunctionDefinition {

	private static final long serialVersionUID = 5226206054978356333L;
	private static final StructuredQName qName = new StructuredQName("", NamespaceConstant.SAXON, "get-message-data");
	
	@Override
	public StructuredQName getFunctionQName() {
		
		return qName;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		
		return new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.SINGLE_STRING};

	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		
		return SequenceType.SINGLE_STRING;
	}
	

	@Override
	public ExtensionFunctionCall makeCallExpression() {
		
		return new MessageDataCall();
	}
	
	private static class MessageDataCall extends ExtensionFunctionCall{

		
		private static final long serialVersionUID = -2430340976152745378L;

		@Override
		public Sequence call(XPathContext context, Sequence[] arguments)
				throws XPathException {
			
			ObjectValue objV = (ObjectValue)arguments[0];
			HL7SupportInterface hl7support = (HL7SupportInterface)objV.getObject();
			String terserPath = ((StringValue)arguments[1]).getStringValue();
		
			return StringValue.makeStringValue(hl7support.getMessageData(terserPath));
			
		}

	}

}
