package gov.va.med.cds.mediator.xml.transform.saxonextensions;

import gov.va.med.cds.checksum.util.IcnChecksum;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;


public class AddCheckSumtoIcnExtFunc extends ExtensionFunctionDefinition {

	private static final long serialVersionUID = 1402717443913199964L;
	private static final StructuredQName qName = new StructuredQName("", NamespaceConstant.SAXON, "add-checksum");
	
	@Override
	public StructuredQName getFunctionQName() {
		
		return qName;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		
		return new SequenceType[]{SequenceType.SINGLE_STRING};

	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		
		return SequenceType.SINGLE_STRING;
	}
	

	@Override
	public ExtensionFunctionCall makeCallExpression() {
		
		return new AddCheckSumCall();
	}
	
	private static class AddCheckSumCall extends ExtensionFunctionCall{

	
		private static final long serialVersionUID = 4428362504919389212L;

		@Override
		public Sequence call(XPathContext context, Sequence[] arguments)
				throws XPathException {
			
			
			LazySequence lz = (LazySequence)arguments[0];
			String icn= lz.head().getStringValue();
		
			
			return StringValue.makeStringValue(IcnChecksum.addChecksumToIcn(icn));
			
		}

	}

}
