

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.formatter.ResponseFormatterInterface;
import gov.va.med.cds.mediator.work.FilterInformation;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.mediator.work.WorkerInterface;


public class VhimXmlReadResponseToHl7Er7Work
    implements
        WorkerInterface
{

    private String wsnCdsVhimReadResponse;

    private String wsnHl7Support;

    private String wsnFilterInformation;

    private String wsnHl7Er7Response;


    public void doWork( WorkStateInterface workState )
    {
        try
        {
            String vhimReadResponse = ( String )workState.locateWorkState( wsnCdsVhimReadResponse );
            HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( wsnHl7Support );
            FilterInformation filterInformation = ( FilterInformation )workState.locateWorkState( wsnFilterInformation );

            // use the response formatter configured for this filter to create the response
            ResponseFormatterInterface responseFormatter = filterInformation.getResponseFormatter();
            String hl7Er7Response = responseFormatter.formatResponse( hl7Support, vhimReadResponse, workState );

            // set the response in the work state object.
            workState.registerWorkState( wsnHl7Er7Response, hl7Er7Response );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }
    }


    public void setWsnCdsVhimReadResponse( String wsnCdsVhimReadResponse )
    {
        this.wsnCdsVhimReadResponse = wsnCdsVhimReadResponse;
    }


    public void setWsnFilterInformation( String wsnFilterInformation )
    {
        this.wsnFilterInformation = wsnFilterInformation;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnHl7Er7Response( String wsnHl7Er7Response )
    {
        this.wsnHl7Er7Response = wsnHl7Er7Response;
    }

}
