

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.hapi.Hl7SupportHdrLegacy;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.mediator.work.WorkerInterface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class RegisterHL7SupportWork
    implements
        WorkerInterface
{
    private final Log logger = LogFactory.getLog( RegisterHL7SupportWork.class );

    private String wsnMessage;

    private String wsnHl7Support;

    private String wsnMsgCtrlId;


    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.cds.mediator.work.IWork#doWork(gov.va.med.cds.mediator.work.IWorkState)
     */
    public void doWork( WorkStateInterface workState )
    {
        String message = ( String )workState.locateWorkState( this.wsnMessage );

        try
        {
            HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( message );

            workState.registerWorkState( this.wsnHl7Support, hl7Support );
            workState.registerWorkState( this.wsnMsgCtrlId, hl7Support.getMessageControlId() );

        }
        catch ( Exception e )
        {
            workState.addException( e );

            try
            {
                // HL7SupportNonHAPI is a simple er7 message parser, it is a Best Effort parser
                HL7SupportInterface hl7Support = new Hl7SupportHdrLegacy( message );

                workState.registerWorkState( this.wsnHl7Support, hl7Support );
                workState.registerWorkState( this.wsnMsgCtrlId, hl7Support.getMessageControlId() );
            }
            catch ( Exception e2 )
            {
                workState.addException( e2 );
            }
        }
    }


    public void setWsnMessage( String wsnMessage )
    {
        this.wsnMessage = wsnMessage;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnMsgCtrlId( String wsnMsgCtrlId )
    {
        this.wsnMsgCtrlId = wsnMsgCtrlId;
    }
}
