

package gov.va.med.cds.mediator.work.cds;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.FilterInformation;
import gov.va.med.cds.mediator.work.WorkStateInterface;


public class ClinicalDataReadMessageWork
    extends
        AbstractClinicalDataServiceWork
{
    private String wsnFilterInformation;


    public void doWork( WorkStateInterface workState )
    {
        try
        {
            HL7SupportInterface hl7Support = getHL7SupportWorkState( workState );
            FilterInformation filterInformation = ( FilterInformation )workState.locateWorkState( this.wsnFilterInformation );

            // Clinical Data Service read request paramaters.
            String templateId = filterInformation.getTemplateId();
            String request = getRequestWorkState( workState );
            String filterId = filterInformation.getFilterId();
            String requestId = hl7Support.getMessageControlId();

            // make the CDS request.
            String response = this.cdsSynchronous.readClinicalData( templateId, request, filterId, requestId /*, false */ );
            setResponseWorkState( workState, response );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }

    }


    public void setWsnFilterInformation( String wsnFilterInformation )
    {
        this.wsnFilterInformation = wsnFilterInformation;
    }

}
