

package gov.va.med.cds.mediator.work.cds;


import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.mediator.work.WorkerInterface;


public abstract class AbstractClinicalDataServiceWork
    implements
        WorkerInterface
{
    protected ClinicalDataServiceInterface cdsSynchronous;

    private String wsnHl7Support;

    private String wsnCdsVhimRequest;

    private String wsnCdsVhimResponse;


    public void setCdsSynchronous( ClinicalDataServiceInterface cdsSynchronous )
    {
        this.cdsSynchronous = cdsSynchronous;
    }


    public void setWsnCdsVhimRequest( String wsnCdsVhimRequest )
    {
        this.wsnCdsVhimRequest = wsnCdsVhimRequest;
    }


    public void setWsnCdsVhimResponse( String wsnCdsVhimResponse )
    {
        this.wsnCdsVhimResponse = wsnCdsVhimResponse;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    protected HL7SupportInterface getHL7SupportWorkState( WorkStateInterface workState )
    {
        return ( HL7SupportInterface )workState.locateWorkState( this.wsnHl7Support );
    }


    protected String getRequestWorkState( WorkStateInterface workState )
    {
        return ( String )workState.locateWorkState( this.wsnCdsVhimRequest );
    }


    protected void setResponseWorkState( WorkStateInterface workState, String response )
    {
        workState.registerWorkState( this.wsnCdsVhimResponse, response );
    }

}
