

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.persistence.Hl7AuditDaoInterface;

import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class ApplicationAcknowledgementWork
    implements
        WorkerInterface,
        ApplicationAcknowledgementMBeanInterface
{

    private static final String COMMIT_ACK = "CA";
    private static final String DOD_DATA = "DOD_DATA";
    private static final String VA_DATA = "VA_DATA";

    private static Log logger = LogFactory.getLog( ApplicationAcknowledgementWork.class );

    private String wsnHl7Support;
    private String wsnCdsVhimResponse;
    private Map<String, NetworkClientProxyInterface> clientProxiesMap;
    private boolean isEnabled = true;
    private Map<String, Hl7AuditDaoInterface> hl7AuditDaoMap = null;


    public void doWork( WorkStateInterface workState )
    {
        if ( isEnabled )
        {
            try
            {
                HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( wsnHl7Support );
                String sendingFacility = hl7Support.getSendingFacility();
                String sentFrom = ( "200CH".equals( sendingFacility ) || "200HD".equals( sendingFacility ) ) ? DOD_DATA : VA_DATA;

                String vhimResponse = ( String )workState.locateWorkState( wsnCdsVhimResponse );

                List<Exception> exceptionList = workState.getExceptions();

                String appAck = hl7Support.getApplicationAcknowledgement( exceptionList, vhimResponse );

                if ( appAck != null )
                {
                    sendAcknowledgementResponse( appAck, hl7Support.getSendingApplication(), hl7Support.getSendingFacility(), sentFrom );
                }
            }
            catch ( Exception e )
            {
                workState.addException( e );
            }
        }
    }


    public boolean isEnabled( )
    {
        return isEnabled;
    }


    public void setEnabled( boolean isEnabled )
    {
        this.isEnabled = isEnabled;
    }


    public void sendAcknowledgementResponse( String acknowledgement, String sendingApp, String sendingFacility, String sentFrom )
    {
        Hl7AuditDaoInterface hl7AuditDao = null;
        NetworkClientProxyInterface clientProxy = clientProxiesMap.get( sendingApp );

        if ( clientProxy != null )
        {
            Properties properties = new Properties();
            properties.setProperty( NetworkClientProxyInterface.PROP_DNS_NAME, sendingFacility );

            // write the acknowledgment to the HL7 Message Log
            HL7SupportInterface hl7supportACK = HL7SupportHAPI.createTranslationSupport( acknowledgement );

            if ( hl7AuditDaoMap != null )
            {
                hl7AuditDao = hl7AuditDaoMap.get( sentFrom );
                hl7AuditDao.addMessage( hl7supportACK.getMessageControlId(), acknowledgement );
            }

            // send the acknowledgment
            String acknowledgmentCommitAck = clientProxy.sendMessage( acknowledgement, properties );

            // Write an error message to the CDS Application Log if other than CA.
            HL7SupportInterface hl7SupportCA = HL7SupportHAPI.createTranslationSupport( acknowledgmentCommitAck );
            if ( !hl7SupportCA.getAcknowledgementCode().equalsIgnoreCase( COMMIT_ACK ) )
            {
                logger.error( String.format( "Error sending acknowledement.\nAcknowledgement: \n%s\n\nCommit Ack:\n%s", acknowledgement,
                                acknowledgmentCommitAck ) );
            }

            // write the CA message to the HL7 Message Log
            if ( hl7AuditDao != null )
            {
                hl7AuditDao.addMessage( hl7supportACK.getMessageControlId(), acknowledgmentCommitAck );
            }
        }
    }


    public void setClientProxiesMap( Map<String, NetworkClientProxyInterface> clientProxiesMap )
    {
        this.clientProxiesMap = clientProxiesMap;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnCdsVhimResponse( String wsnCdsVhimResponse )
    {
        this.wsnCdsVhimResponse = wsnCdsVhimResponse;
    }


    public void setHl7AuditDaoMap( Map<String, Hl7AuditDaoInterface> hl7AuditDaoMap )
    {
        this.hl7AuditDaoMap = hl7AuditDaoMap;
    }
}
