/*
 *
 * Department of Veterans Affairs
 * OI Field Office - Salt Lake City
 * Health Data Systems
 */


package gov.va.med.cds.mediator.persistence;


public interface Hl7AuditDaoInterface
{

    /**
     * Adds a message to the thread of messages. This method is to be called when subsequest message 
     * need to be associated with an original message in the HL7 audit data store.
     * @param messageControlId The message control ID of the message that this message is supposed to 
     * be associated with.
     * @param message The message to be added to the thread.
     * @throws DataAccessException If anything goes wrong while adding the message to the thread.
     */
    void addMessage( String messageControlId, String message );
}
