

package gov.va.med.cds.client.proxy;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.SocketClientException;
import gov.va.med.cds.util.MllpUtil;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xsocket.connection.IBlockingConnection;


public abstract class AbstractMllpSocketBasedClientProxy
    implements
        NetworkClientProxyInterface

{
    private static Log logger = LogFactory.getLog( AbstractMllpSocketBasedClientProxy.class );

    private IBlockingConnectionFactory blockingConnectionFactory = null;

    private int port;


    public abstract ByteBuffer sendMessage( ByteBuffer message, Properties properties );


    public String sendMessage( String message, Properties properties )
    {
        // convert the message string to a ByteBuffer
        ByteBuffer msgBuffer = ByteBuffer.wrap( message.getBytes() );

        // call sendMessage with a ByteBuffer
        ByteBuffer respBuffer = sendMessage( msgBuffer, properties );

        // Convert the returned ByteBufer to string
        String response = new String( respBuffer.array() );

        // return the string
        return response;
    }


    public ByteBuffer sendMessage( ByteBuffer acknowledgement, String host )
    {
        ByteBuffer response = null;
        IBlockingConnection blockingConnection = null;
        try
        {
            blockingConnection = blockingConnectionFactory.getConnection( host, port );
            blockingConnection.setAutoflush( false );
            blockingConnection.write( MllpUtil.encode( acknowledgement, Charset.defaultCharset(), Charset.forName( "ISO-8859-1" ) ) );
            blockingConnection.flush();
            
   	    	ByteBuffer buffer = ByteBuffer.allocate(2048); // allocate a 2K buffer to store the CA in.
    	    int read = blockingConnection.read(buffer);
    	    buffer.limit(read-1);
    	    response = MllpUtil.decode( new ByteBuffer[]{buffer}, Charset.forName( "ISO-8859-1" ), Charset.defaultCharset() );
        }
        catch ( BufferOverflowException boe )
        {
            // logger.error( "Buffer Overflow Exception:", boe );
        }
        catch ( Exception e )
        {
            logger.error( "Socket timeout exception occurred when writing message ", e );
            throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, e );
        }
        finally
        {
            if ( blockingConnection != null )
            {
                try
                {
                    blockingConnection.close();
                }
                catch ( IOException e )
                {
                    logger.error( "Error closing connection.", e );
                }
            }
        }

        return response;
    }


    public void setBlockingConnectionFactory( IBlockingConnectionFactory blockingConnectionFactory )
    {
        this.blockingConnectionFactory = blockingConnectionFactory;
    }


    public void setPort( int port )
    {
        this.port = port;
    }
}
