/**
 * 
 */
package gov.va.med.cds.client;

import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterfaceLocator;
import gov.va.med.cds.exception.ClinicalDataServiceCreateException;
import gov.va.med.cds.registry.JAXRUtility;

import java.net.URL;

import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Service;

/**
 * @author vhaislegberb
 * 
 */
public class ClinicalDataServiceFactory {

	private String serviceBindingId = null;

	private JAXRUtility jaxrHelper = null;

	public synchronized gov.va.med.cds.client.ClinicalDataServiceInterface create() 
	{
		try 
		{
			return getBusinessDelegate();
		} 
		catch (Exception ex) 
		{
			throw new ClinicalDataServiceCreateException("Could not create CDS web service client.", ex);
		}
	}

	private gov.va.med.cds.client.ClinicalDataServiceInterface getBusinessDelegate()
	{
		try 
		{
			
	    	Service service = (Service) jaxrHelper.findByIdAndType(serviceBindingId, LifeCycleManager.SERVICE);
			URL endpoint = jaxrHelper.serviceToServiceEndpointURL(service);

			ClinicalDataServiceSynchronousInterfaceLocator cdsServiceLocator = new ClinicalDataServiceSynchronousInterfaceLocator();
			cdsServiceLocator.setEndpointAddress(new javax.xml.namespace.QName("http://client.cds.domain.ext","ClinicalDataServiceSynchronousInterfaceHttpPort"), endpoint.toString());
			gov.va.med.cds.client.webservice.ClinicalDataServiceInterface port = cdsServiceLocator.getClinicalDataServiceSynchronousInterfaceHttpPort();
			ClinicalDataServiceProxy serviceDelegate = new ClinicalDataServiceProxy();
			serviceDelegate.setProxy(port);
			return serviceDelegate;

		} catch (Exception e) 
		{
			throw new ClinicalDataServiceCreateException("Error find ing CDS service in UDDI registry", e);
		}
	}

	public void setServiceBindingId(String serviceBindingId) 
	{
		this.serviceBindingId = serviceBindingId;
	}

	public void setJaxrHelper(JAXRUtility jaxrHelper) 
	{
		this.jaxrHelper = jaxrHelper;
	}
}
