

package gov.va.med.mediator.client.messagemediator.legacy;


import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.isA;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.MllpUtil;
import gov.va.med.mediator.client.messagemediator.MediatorException;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.xsocket.connection.IBlockingConnection;

@RunWith( SuiteAwareRunner.class )
public class TCPSocketMessageMediatorTest
{
    private TCPSocketMessageMediator mediator;
    private IBlockingConnection blockingConnectionMock;
    protected boolean calledDestroyBlockingConnection = false;


    @Test
    @Suite( groups = "checkintest" )
    public void testIsAlive( )
        throws Exception
    {
        mediator = new TCPSocketMessageMediator();
        // connection pool is final BlockingConnectionPool can't mock
        mediator.setConnectionPool( null );
        mediator.setTcpMediatorHost( "host" );
        mediator.setTcpMediatorPort( 3 );
        assertTrue( mediator.isAlive() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testProccessMessage( )
        throws Exception
    {
        blockingConnectionMock = createMock( IBlockingConnection.class );
        mediator = new TCPSocketMessageMediator()
        {
            @Override
            IBlockingConnection getBlockingConnection( )
                throws IOException,
                    SocketTimeoutException
            {
                return blockingConnectionMock;
            }
        };

        String hl7MessageRequest = "mock hl7 request";
        expect( blockingConnectionMock.write( isA( String.class ) ) ).andReturn( 1 );
        blockingConnectionMock.flush();
        blockingConnectionMock.close();
        expect( blockingConnectionMock.readByteBufferByDelimiter( isA( String.class ) ) ).andReturn(new ByteBuffer[]{MllpUtil.encode(ByteBuffer.wrap("mock HL7 response".getBytes()), Charset.defaultCharset(), Charset.forName("ISO-8859-1"))});
        replay( blockingConnectionMock );
        mediator.processMessage( hl7MessageRequest );

        verify( blockingConnectionMock );
    }


    @Test( expected = MediatorException.class )
    @Suite( groups = "checkintest" )
    public void testProcessMessage_MediatorException( )
        throws Exception
    {
        mediator = new TCPSocketMessageMediator()
        {
            @Override
            IBlockingConnection getBlockingConnection( )
                throws IOException,
                    SocketTimeoutException
            {
                throw new SocketTimeoutException();
            }
        };

        String hl7MessageRequest = "mock hl7 request";
        mediator.processMessage( hl7MessageRequest );

        verify( blockingConnectionMock );

    }


    @Test( expected = MediatorException.class )
    @Suite( groups = "checkintest" )
    public void testProccessMessage_IOException( )
        throws Exception
    {

        blockingConnectionMock = createMock( IBlockingConnection.class );
        mediator = new TCPSocketMessageMediator()
        {
            @Override
            IBlockingConnection getBlockingConnection( )
                throws IOException,
                    SocketTimeoutException
            {
                return blockingConnectionMock;
            }


            @Override
            void destroyBlockingConnection( IBlockingConnection blockingConnection )
                throws IOException
            {
                calledDestroyBlockingConnection = true;
            }

        };

        String hl7MessageRequest = "mock hl7 request";
        expect( blockingConnectionMock.write( isA( String.class ) ) ).andReturn( 1 );
        blockingConnectionMock.flush();
        blockingConnectionMock.close();
        expect( blockingConnectionMock.readByteBufferByDelimiter( isA( String.class ) ) ).andThrow( new IOException() );
        replay( blockingConnectionMock );
        mediator.processMessage( hl7MessageRequest );
        assertTrue( calledDestroyBlockingConnection );
        assertNull( blockingConnectionMock );
        verify( blockingConnectionMock );
    }

}
