

package gov.va.med.mediator.client.messagemediator;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.jms.BytesMessage;
import javax.jms.Session;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;


@RunWith( SuiteAwareRunner.class )
public class JmsMessageMediatorDelegateTest
{

    @Before
    public void beforeJmsMessageMediatorDelegateTestMethodSetUp( )
        throws Exception
    {
        final Map<String, JmsTemplate> jmsTemplateMap = new HashMap<String, JmsTemplate>();
        jmsTemplateMap.put( "CHDR_QUEUE", new JmsTemplate() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsAliveMediatorSynchronousNotNullandMediatorSynchronousAlive( )
    {

        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        Assert.assertTrue( jmsMessageMediatorDelegate.isAlive() );

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testProcessMessageSendingOrganizationVHA( )
        throws IOException
    {

        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate(){
        	@Override
        	protected String getVDEFString(String message) {
        		return "its all good";
        	}
        };

        String hl7Request = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdralgy.er7" ) );
        jmsMessageMediatorDelegate.setSendingOrganization( "VHA" );
        String result = jmsMessageMediatorDelegate.processMessage( hl7Request );
        Assert.assertNotNull( result );

    }
    
    
    @Test
    @Suite( groups = "checkintest" )
    public void testGetSendingApplicationHdralgy()
        throws Exception
    {
        String hl7Request = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdralgy.er7" ) );
        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        String result = jmsMessageMediatorDelegate.getMessageSendingApplication( hl7Request );
        Assert.assertEquals( "HDRALGY", result );

    }
    
    
    @Test
    @Suite( groups = "checkintest" )
    public void testGetSendingApplicationLa7labGood()
        throws Exception
    {
        String hl7Request = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdrlab.er7" ) );
        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        String result = jmsMessageMediatorDelegate.getMessageSendingApplication( hl7Request );
        Assert.assertEquals( "LA7LAB", result );

    }
    
    
    @Test
    @Suite( groups = "checkintest" )
    public void testGetSendingApplicationLa7labBadObx2()
        throws Exception
    {
        String hl7Request = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdrlab-bad-obx2.er7" ) );
        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        String result = jmsMessageMediatorDelegate.getMessageSendingApplication( hl7Request );
        Assert.assertEquals( "LA7LAB", result );

    }


    @Test
    @Suite( order = 1, groups = "checkintest" )
    public void testProcessMessageSendingOrganizationDOD( )
        throws IOException
    {

        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();

        String hl7Request = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdralgy.er7" ) );
        jmsMessageMediatorDelegate.setSendingOrganization( "DOD" );
        String result = jmsMessageMediatorDelegate.processMessage( hl7Request );
        Assert.assertNotNull( result );

    }

    
    @Test
    @Suite( order = 2, groups = "checkintest", dependsOnMethods = { "testProcessMessageSendingOrganizationDOD" } )
    public void testGetMessageSendingApplication( )
        throws Exception
    {

        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        String hl7MessageRequest = StreamUtil.resourceToString( new ClassPathResource( "gov/va/med/mediator/client/messagemediator/hdralgy.er7" ) );

        jmsMessageMediatorDelegate.setSendingOrganization( "VHA" );

        Assert.assertNotNull( jmsMessageMediatorDelegate.processMessage( hl7MessageRequest ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSendFromJMSTemplateforTrueFlag( )
        throws Exception
    {

        boolean persistOriginalMessage = true;
        String hl7MessageRequest = "hl7MessageRequest";

        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        JmsTemplate _JmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        MessageCreator messageCreatorMock = EasyMock.createMock( MessageCreator.class );
        Session sessionMock = EasyMock.createMock( Session.class );
        BytesMessage messageMock = EasyMock.createNiceMock( BytesMessage.class );
        EasyMock.expect( sessionMock.createBytesMessage() ).andReturn( messageMock );
        EasyMock.expect( messageCreatorMock.createMessage( sessionMock ) ).andReturn( messageMock );
        _JmsTemplateMock.send( messageCreatorMock );
        EasyMock.replay( messageCreatorMock, sessionMock, messageMock );
        jmsMessageMediatorDelegate.sendFromJMSTemplate( _JmsTemplateMock, hl7MessageRequest, persistOriginalMessage );
        EasyMock.verify();
    }
    
    @Test
    @Suite( groups = "checkintest" )
    public void testGetVDEFString() throws Exception {
        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate();
        String message = "Uncategorized exception occured during JMS processing; nested exception is weblo6 020210.154624  VDEFVIE4";
		String vdefString = jmsMessageMediatorDelegate.getVDEFString(message );
		Assert.assertEquals("VDEFVIE4", vdefString);
        message = "Uncategorized exception occured during JMS processing; nested exception is weblo6 020210.154624  VDEFVIE4 folloewd by more";
		vdefString = jmsMessageMediatorDelegate.getVDEFString(message );
		Assert.assertEquals("VDEFVIE4", vdefString);
        message = "Uncategorized exception occured during JMS processing; nested exception is weblo6 020210.154624";
		vdefString = jmsMessageMediatorDelegate.getVDEFString(message );
		Assert.assertEquals("", vdefString);

	}
 
    @Test
    @Suite( groups = "checkintest" )
    public void testCreateErrorMessage() throws Exception {
        JmsMessageMediatorDelegate jmsMessageMediatorDelegate = new JmsMessageMediatorDelegate(){
        	@Override
        	protected String createMessageDateTime() {
        		return "20100214.123456";
        	}
        };
        String exceptionMessage = "Uncategorized exception occured during JMS processing; nested exception is weblo6 020210.154624  VDEFVIE4";
		String errorMesssage = jmsMessageMediatorDelegate.createErrorMessage(exceptionMessage);
		String expected = "<errorSection>CDS-Socket-Facade: Error sending message to queue. 20100214.123456 VDEFVIE4</errorSection>";
		Assert.assertEquals(expected, errorMesssage);

         exceptionMessage = "org.springframework.jms.UncategorizedJmsException: Uncategorized exception occured during JMS processing; nested exception is weblogic.jms.common.JMSException: [JMSClientExceptions:055053]Error creating connection to the server: java.rmi.ConnectException: Could not establish a connection with -8904970591731528053S:127.0.0.1:[PORT,PORT,-1,-1,-1,-1,-1]:dev_srvr:dev_srvr.admin, java.rmi.ConnectException: Destination unreachable; nested exception is:" ;
		 errorMesssage = jmsMessageMediatorDelegate.createErrorMessage(exceptionMessage);
		 expected = "<errorSection>CDS-Socket-Facade: Error sending message to queue. 20100214.123456 </errorSection>";
		 Assert.assertEquals(expected, errorMesssage);

	}
}
