

package gov.va.med.mediator.client.messagemediator.legacy;


import gov.va.med.mediator.client.messagemediator.MediatorException;
import gov.va.med.mediator.client.messagemediator.MessageMediatorInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.util.MllpUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xsocket.connection.BlockingConnectionPool;
import org.xsocket.connection.IBlockingConnection;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;


/**
 * @author vhaislegberb
 * 
 */
public class TCPSocketMessageMediator
    implements
        MessageMediatorInterface
{

    private static Log logger = LogFactory.getLog( TCPSocketMessageMediator.class );

    private BlockingConnectionPool connectionPool; // injected

    private String tcpMediatorHost; // injected

    private int tcpMediatorPort; // injected


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#isAlive()
     */
    public boolean isAlive( )
    {
        // assume that it's alive.
        return true;
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String)
     */
    public String processMessage( String hl7MessageRequest )
    {
        logger.info( "Entering processMessage method." );
        IBlockingConnection blockingConnection = null;
        String response = null;

        try
        {
            logger.info( "Getting blocking connection from connection pool." );
            blockingConnection = getBlockingConnection();

            logger.info( "Writing request to server." );

            String encoded = MllpUtil.encode( ByteBuffer.wrap( hl7MessageRequest.getBytes() ), Charset.defaultCharset(), Charset.forName("ISO-8859-1") ).toString();
            blockingConnection.write( encoded );
            blockingConnection.flush();
            logger.info( "Request written." );

            logger.info( "Reading response from server." );
            ByteBuffer[] buffer = blockingConnection.readByteBufferByDelimiter( String.valueOf( ( char )MllpUtil.EOB ) );
            response = MllpUtil.decode( buffer, Charset.forName( "ISO-8859-1" ), Charset.defaultCharset() ).toString();
        }
        catch ( SocketTimeoutException e )
        {
            logger.error( "The socket timed out.", e );
            throw new MediatorException( ErrorCodeEnum.MEDIATOR_TCP_SOCKET_CLIENT_ERROR, e );
        }
        catch ( BufferOverflowException e )
        {
            logger.error( "The buffer over-floweth.", e );
            throw new MediatorException( ErrorCodeEnum.MEDIATOR_TCP_SOCKET_CLIENT_ERROR, e );
        }
        catch ( IOException e )
        {
            logger.error( "An IO error occurred. Connection will be destroyed.", e );
            if ( blockingConnection != null )
            {
                try
                {
                    logger.warn( "Destroying blocking connection." );
                    destroyBlockingConnection( blockingConnection );
                    blockingConnection = null;
                    logger.warn( "Blocking connection destroyed." );
                }
                catch ( IOException e1 )
                {
                    logger.error( "An error occurred while destroying the blocking connection.", e1 );
                }
            }
            throw new MediatorException( ErrorCodeEnum.MEDIATOR_TCP_SOCKET_CLIENT_ERROR, e );
        }
        finally
        {
            if ( blockingConnection != null )
            {
                try
                {
                    logger.info( "Closing the blocking connection." );
                    blockingConnection.close();
                    blockingConnection = null;
                    logger.info( "Blocking connection closed." );
                }
                catch ( IOException e )
                {
                    logger.error( "An error occured while trying to close the blocking connection.", e );
                }
            }
        }

        return response;
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.client.messagemediator.MessageMediatorInterface#processMessage(java.lang.String, java.lang.Boolean)
     */
    public String processMessage( String hl7MessageRequest, Boolean persistOriginalMessage )
    {
        return processMessage( hl7MessageRequest );
    }


    public void setConnectionPool( BlockingConnectionPool connectionPool )
    {
        this.connectionPool = connectionPool;
    }


    public void setTcpMediatorHost( String tcpMediatorHost )
    {
        this.tcpMediatorHost = tcpMediatorHost;
    }


    public void setTcpMediatorPort( int tcpMediatorPort )
    {
        this.tcpMediatorPort = tcpMediatorPort;
    }


    /*
     * Convenience methods for unit testing
     */
    IBlockingConnection getBlockingConnection( )
        throws IOException,
            SocketTimeoutException
    {
        return this.connectionPool.getBlockingConnection( tcpMediatorHost, tcpMediatorPort );
    }


    void destroyBlockingConnection( IBlockingConnection blockingConnection )
        throws IOException
    {
        this.connectionPool.destroy( blockingConnection );
    }

}
