/**
 * 
 */


package gov.va.med.cds.log4j;


import gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface;

import org.apache.log4j.spi.LoggingEvent;
import org.springframework.context.ApplicationContext;


/**
 * @author vhaislegberb
 *
 */
public class SpringAwareDbAppender
    extends
        AbstractSpringAwareProxy
{

    private LoggerPersistenceManagerInterface loggerPersistenceManager;


    @Override
    protected void append( LoggingEvent event )
    {
        ApplicationLogEvent appLogEvent = new ApplicationLogEvent( event );
        loggerPersistenceManager.persistApplicationLogEvent( appLogEvent );
    }


    @Override
    public void activateOptions( )
    {
        super.activateOptions();

        ApplicationContext appContext = getApplicationContext();
        if ( appContext != null )
        {
            loggerPersistenceManager = ( LoggerPersistenceManagerInterface )appContext.getBean( "loggerPersistenceManager" );
        }

    }


    /*
     * (non-Javadoc)
     * @see org.apache.log4j.AppenderSkeleton#requiresLayout()
     */
    public boolean requiresLayout( )
    {
        return false;
    }


    @Override
    public void close( )
    {
        // no-op
    }

}