

package gov.va.med.cds.log4j;


import org.apache.log4j.Appender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.springframework.context.ApplicationContext;


/**
 * 
 * This class is a Proxy to an AOP proxy for JMS Appender.  All calls upon this
 * class are passed on to a Spring configured AOP proxy of a RuntimeConfigurableAppender
 * 
 * @author VHAISLTALBOM
 *
 */
public class SpringAwareAppenderProxy
    extends
        AbstractSpringAwareProxy
{
    private Appender aopProxy;


    @Override
    protected void append( LoggingEvent loggingevent )
    {
        aopProxy.doAppend( loggingevent );
    }


    @Override
    public void close( )
    {
        aopProxy.close();
    }


    @Override
    public boolean requiresLayout( )
    {
        return false;
    }


    @Override
    public void activateOptions( )
    {
        super.activateOptions();

        ApplicationContext appContext = getApplicationContext();
        if ( appContext != null )
        {
            this.aopProxy = ( Appender )appContext.getBean( "aop-proxy" );

            ( ( OptionHandler )aopProxy ).activateOptions();
        }
    }
}