

package gov.va.med.cds.log4j;


import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.Scanner;


/**
 * 
 * @author vhaislthummp
 *
 */
public class ApplicationLogEvent
{
    private Long id;

    private String domainName;

    private String requestId;

    private String message;

    private Date localTime;

    private String severity;

    private String appName;

    private static final String DOMAIN_NAME = "<<domain name>>";
    private static final String REQUEST_ID = "<<request id>>";
    private static final String APP_NAME = "<<app name>>";
    private static final String MESSAGE_DELIMITER = "#";


    public ApplicationLogEvent( )
    {
    }


    /**
     * Use Log4J log event to populate the CDS application log event.
     * @param logEvent 
     */
    public ApplicationLogEvent( LoggingEvent logEvent )
    {
        String message = ( String )logEvent.getMessage();
        if ( null != message && 0 != message.length() )
        {
            extractData( message );

            //Append throwable information if exists
            ThrowableInformation throwableInfo = logEvent.getThrowableInformation();
            StringBuilder tempMessage = new StringBuilder();

            if ( throwableInfo != null && throwableInfo.getThrowableStrRep().length > 0 )
            {
                String[] stringReps = throwableInfo.getThrowableStrRep();
                tempMessage.append( getMessage() );
                tempMessage.append( "Appending Throwable information - " );
                for ( String rep : stringReps )
                {
                    tempMessage.append( rep );
                }
                setMessage( tempMessage.toString() );
            }

            //setMessage(myString);
            setLocalTime( new Date() );
            setSeverity( logEvent.getLevel().toString() );
        }
    }


    private void extractData( String message )
    {
        if ( !message.contains( MESSAGE_DELIMITER ) )
        {
            this.setDomainName( DOMAIN_NAME );
            this.setRequestId( REQUEST_ID );
            this.setAppName( APP_NAME );
            this.setMessage( message );

        }
        else
        {
            Scanner scanner = new Scanner( message ).useDelimiter( MESSAGE_DELIMITER );
            String value = null;
            
            // 1st position - domainName
            if ( scanner.hasNext() )
            {
                value = scanner.next();
                if ( !StringUtils.hasText( value ) )
                {
                    this.setDomainName( DOMAIN_NAME );
                }
                else
                {
                    this.setDomainName( value );
                }
            }

            // 2end position - RequestId
            if ( scanner.hasNext() )
            {
                value = scanner.next();
                if ( !StringUtils.hasText( value ) )
                {
                    this.setRequestId( REQUEST_ID );
                }
                else
                {
                    this.setRequestId( value );
                }

            }

            // 3rd position - AppName

            if ( scanner.hasNext() )
            {
                value = scanner.next();
                if ( !StringUtils.hasText( value ) )
                {
                    this.setAppName( APP_NAME );
                }
                else
                {
                    this.setAppName( value );
                }

            }

            // 4th position - Exception/Error Message
            if ( scanner.hasNext() )
            {
                this.setMessage( scanner.next() );
            }
        }
    }


    public String getDomainName( )
    {
        return domainName;
    }


    public void setDomainName( String domainName )
    {
        this.domainName = domainName;
    }


    public String getRequestId( )
    {
        return requestId;
    }


    public void setRequestId( String requestId )
    {
        this.requestId = requestId;
    }


    public String getMessage( )
    {
        return message;
    }


    public void setMessage( String message )
    {
        this.message = message;
    }


    public Date getLocalTime( )
    {
        return localTime;
    }


    public void setLocalTime( Date localTime )
    {
        this.localTime = localTime;
    }


    public String getSeverity( )
    {
        return severity;
    }


    public void setSeverity( String severity )
    {
        this.severity = severity;
    }


    public String getAppName( )
    {
        return appName;
    }


    public void setAppName( String appName )
    {
        this.appName = appName;
    }


    public Long getId( )
    {
        return id;
    }
}
