

package gov.va.med.cds.log4j;


import org.apache.log4j.AppenderSkeleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;


public abstract class AbstractSpringAwareProxy
    extends
        AppenderSkeleton
{

    protected enum SpringConfigResourceType { FILE, CLASSPATH };
    protected String[] springConfigurations;
    protected SpringConfigResourceType springConfigResourceType;
    
    /**
     * 
     * @param springConfigurations
     */
    public void setSpringConfigurations(String springConfigurations) {
        this.springConfigurations = springConfigurations.split(",");
    }
    

    /**
     * 
     * @param springConfigResourceType
     */
    public void setSpringConfigResourceType( String springConfigResourceType) {
        this.springConfigResourceType = SpringConfigResourceType.valueOf(springConfigResourceType);
    }
    
    protected ApplicationContext getApplicationContext(){

        ApplicationContext appContext = null;
       
        switch ( springConfigResourceType )
        {
        case FILE:
            appContext = new FileSystemXmlApplicationContext(springConfigurations);
            break;
        case CLASSPATH:
        default:
            appContext = new ClassPathXmlApplicationContext(springConfigurations);
            break;
        }
        
        return appContext;
        
    }
}
