

package gov.va.med.cds.junit.runnners;


import static org.junit.Assert.fail;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class GroupAwareRunnerTest
{

    @Test
    @Suite( groups = "prototypetest" )
    public void testsRun( )
    {
        Result result = JUnitCore.runClasses( TestRunner.class );
        Assert.assertEquals( 3, result.getRunCount() );
        Assert.assertEquals( 1, result.getFailureCount() );
    }

    public static class ExampleGroupAwareRunner
        extends
            SuiteAwareRunner
    {

        public static String sysGroups = System.getProperty( "cds.test.groups" );

        static
        {
            System.setProperty( "cds.test.groups", "prototypetest" );
        }


        public ExampleGroupAwareRunner( Class<?> klass )
            throws Exception
        {
            super( klass );
        }
    }

    @RunWith( ExampleGroupAwareRunner.class )
    public static class TestRunner
    {

        @AfterClass
        static public void afterPropertiesUtilTestClassSetUp( )
        {
            if ( ExampleGroupAwareRunner.sysGroups != null )
            {
                System.setProperty( "cds.test.groups", ExampleGroupAwareRunner.sysGroups );
            }
        }


        @Test
        @Suite( groups = "prototypetest" )
        public void testA( )
        {
            fail( " 'notMyTestGroup' not included, this test should never run" );
        }


        @Test
        @Suite( groups = "prototypetest" )
        public void aTest( )
        {
            Assert.assertTrue( "This test should run", true );
        }


        @Test
        @Suite( groups = "prototypetest" )
        public void bTest( )
        {
            Assert.assertTrue( "This test should run", true );
        }
    }
}
