

package gov.va.med.cds.junit.runners;


import java.util.List;

import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;


public class SuiteAwareRunner extends BlockJUnit4ClassRunner
{
    private boolean keepExecution = true;


    public SuiteAwareRunner( Class<?> klass )
        throws InitializationError,
            NoTestsRemainException
    {
        super( klass );
        filter( new GroupAwareFilter() );
        sort( new Sorter( new DependancyComparator() ) );
    }


    @Override
    protected List<FrameworkMethod> computeTestMethods( )
    {
        List<FrameworkMethod> methods = super.computeTestMethods();
        RunnerUtils.addCustomBeforeAndAfterOnceMethods( getTestClass(), methods );        
        return methods;
    }


    @Override
    public void filter( Filter filter )

    {
        try
        {
            super.filter( filter );
        }
        catch ( NoTestsRemainException e )
        {
            keepExecution = false;

        }
    }


    @Override
    public void sort( Sorter sorter )
    {
        if ( !keepExecution )
            return;
        super.sort( sorter );
    }
}
