

package gov.va.med.cds.junit.runners;


import java.util.List;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;


public class RunnerUtils
{
    public static final int HIGH = Integer.MAX_VALUE;
    public static final int LOW = Integer.MIN_VALUE;
    public static final Class<AfterTestsOnce> AFTER_TESTS_ONCE = gov.va.med.cds.junit.runners.AfterTestsOnce.class;
    public static final Class<BeforeTestsOnce> BEFORE_TESTS_ONCE = gov.va.med.cds.junit.runners.BeforeTestsOnce.class;
    public static final Class<gov.va.med.cds.junit.runners.Suite> MARKER_CLASS = gov.va.med.cds.junit.runners.Suite.class;


    /*
     * Include custom annotations for custom setup and tear down methods that run only once before and after test methods
     */
    public static void addCustomBeforeAndAfterOnceMethods( TestClass testClass, List<FrameworkMethod> methods )
    {
        // @BeforeTestsOnce and @AfterTestsOnce are only run once for parent class and not apply to children
        List<FrameworkMethod> customAnotatedMethods = testClass.getAnnotatedMethods( BEFORE_TESTS_ONCE );
        customAnotatedMethods.addAll( testClass.getAnnotatedMethods( AFTER_TESTS_ONCE ));
        if ( !methods.containsAll( customAnotatedMethods ) )
        {
            methods.addAll( customAnotatedMethods );
        }
                
    }
}
