/**
 * 
 */


package gov.va.med.cds.idm.client.stub;


import static org.junit.Assert.*;

import java.util.Collection;

import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


/**
 * @author susarlan
 *
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/idm/client/stub/idmPersonIdentifierManagementStubContext.xml" } )
public class IdmPersonIdentifierManagementStubTest
{
    private IdmPersonIdentifierManagementStub patientIdentifierCorrelation;


    /**
     * Test method for {@link gov.va.med.cds.idm.client.stub.IdmPersonIdentifierManagementStub#obtainPersonIdentifiers(gov.va.med.cds.common.person.correlation.PersonIdentifierInterface)}.
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testObtainPersonIdentifiers( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( "1008523096V381537" );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        Collection<PersonIdentifierInterface> response = patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier );
        assertTrue( response.size() > 0 );

        PersonIdentifierInterface personIdentifier2 = new PersonIdentifier();
        personIdentifier2.setIdentity( "1008183660V228191" );
        personIdentifier2.setAssigningFacility( "200M" );
        personIdentifier2.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        response = patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier2 );
        assertTrue( response.size() == 1 );
    }


    @Resource
    public void setPatientIdentifierCorrelation( IdmPersonIdentifierManagementStub patientIdentifierCorrelation )
    {
        this.patientIdentifierCorrelation = patientIdentifierCorrelation;
    }
}
