package gov.va.med.cds.idm.client;

import static org.junit.Assert.assertTrue;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.Collection;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith( SuiteAwareRunner.class )
public class IdmPersonIdentifierManagementMockTest {
	
	private String idmRequest = "<IDM_REQUEST type='GET_CORRESPONDING_IDS'>"+
	                                "<METADATA>" +
	                                "<FIELD name='SENDINGFACILITY' value='200CDS'/>" +
	                                "</METADATA>" +
									"<ARGUMENTS>"+
										"<ARGUMENT name='sourceId'>"+
											"<IDENTIFIER type='NI'>"+
												"<ID>%%REPLACE_ICN_VALUE%%</ID>"+
												"<ISSUER>%%REPLACE_ASSIGINING_AUTHORITY%%</ISSUER>"+
												"<SOURCE>%%REPLACE_ASSIGINING_FACILITY%%</SOURCE>"+
											"</IDENTIFIER>"+
										"</ARGUMENT>"+
										"<ARGUMENT name='statusList'>"+
											"<VALUE>A</VALUE>"+
											"<VALUE>H</VALUE>"+
										"</ARGUMENT></ARGUMENTS></IDM_REQUEST>";

	@Test
    @Suite( groups = "checkintest" )
    public void testObtainPersonIdentifiers( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( "1008523096V381537" );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );
        
        String idmServiceResponse = "<IDM_RESPONSE type='GET_CORRESPONDING_IDS'>" +
                                    "<METADATA><FIELD name='count' value='3'/></METADATA>" +
                                    "<RESULT type='AA'>" + 
                                    "<IDENTIFIER type='PI'><ID>Local_1</ID><SOURCE>992</SOURCE><ISSUER>USVHA</ISSUER><STATUS>A</STATUS></IDENTIFIER>" +
                                    "<IDENTIFIER type='PI'><ID>Local_2</ID><SOURCE>992</SOURCE><ISSUER>USVHA</ISSUER><STATUS>H</STATUS></IDENTIFIER>" +
                                    "<IDENTIFIER type='NI' subtype='IDM'><ID>National_1</ID><STATUS>P</STATUS><EFFECTIVE>20100820</EFFECTIVE></IDENTIFIER>" +
                                    "</RESULT>" +
                                    "</IDM_RESPONSE>";

        
        IdmPersonServiceInterface idmPersonServiceMock = EasyMock.createMock(IdmPersonServiceInterface.class);
        EasyMock.expect(idmPersonServiceMock.getCorrespondingIds(EasyMock.isA(String.class))).andReturn(idmServiceResponse);
        EasyMock.replay(idmPersonServiceMock);
        
        IdmPersonIdentifierManagement  personIdentifierCorrelationService = new IdmPersonIdentifierManagement();
        personIdentifierCorrelationService.setIdmPersonService( idmPersonServiceMock );
        personIdentifierCorrelationService.setCorrespondingIdsRequestXml(idmRequest);
        

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        Collection<PersonIdentifierInterface> response = personIdentifierCorrelationService.obtainPersonIdentifiers( personIdentifier );
        assertTrue( response.size() == 3 );
        
        PersonIdentifierInterface[] pids = response.toArray(new PersonIdentifierInterface[]{});
        Assert.assertEquals( "USVHA", pids[2].getAssigningAuthority());
        Assert.assertEquals( "200M", pids[2].getAssigningFacility());
        
        EasyMock.verify(idmPersonServiceMock);
    }
}
