/**
 * 
 */

package gov.va.med.cds.idm.client;

import gov.va.med.cds.exception.IdmPersonServiceCreateException;
import gov.va.med.cds.idm.client.webservice.PSIMWebServiceLocator;
import gov.va.med.cds.idm.client.webservice.PSIMWebServicePort;
import gov.va.med.cds.idm.client.webservice.PSIMWebServicePortStub;
import gov.va.med.cds.registry.JAXRUtility;

import java.net.URL;

import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Service;
import javax.xml.rpc.ServiceException;

/**
 * @author susarlan
 * 
 */
public class IdmPersonServiceFactory {
	private String serviceBindingId = null;

	private JAXRUtility jaxrHelper = null;

	public synchronized IdmPersonServiceInterface create(
			Integer idmWebserviceTimeoutSecs) {

		try {
			IdmPersonServiceDelegate delegate = new IdmPersonServiceDelegate();
			PSIMWebServicePort idmWebservicePort = getBusinessDelegate(idmWebserviceTimeoutSecs);
			delegate.setIdmService(idmWebservicePort);
			
			return delegate;

		} catch (Exception ex) {
			throw new IdmPersonServiceCreateException(
					"Could not create a business delegate via Caip.", ex);
		}
	}

	private PSIMWebServicePort getBusinessDelegate(Integer idmWebserviceTimeoutSecs) throws ServiceException {
		try {

			Service service = (Service) jaxrHelper.findByIdAndType(
					serviceBindingId, LifeCycleManager.SERVICE);
			URL endpoint = jaxrHelper.serviceToServiceEndpointURL(service);
			PSIMWebServiceLocator psimWsLocator = new PSIMWebServiceLocator();
			psimWsLocator.setEndpointAddress(new javax.xml.namespace.QName("PSIM", "PSIMWebServicePort"),
					endpoint.toString());
			
			PSIMWebServicePortStub port = (PSIMWebServicePortStub)psimWsLocator.getPSIMWebServicePort();

			if (idmWebserviceTimeoutSecs != null) {
				port.setTimeout(idmWebserviceTimeoutSecs * 1000);
			}
			return port;

		} catch (Exception e) {
			throw new ServiceException("Error finding service in registry.", e);
		}
	}

	public void setJaxrHelper(JAXRUtility jaxrHelper) {
		this.jaxrHelper = jaxrHelper;
	}

	public void setServiceBindingId(String serviceBindingId) {
		this.serviceBindingId = serviceBindingId;
	}

}
