package gov.va.med.cds.idm.client;

import java.rmi.RemoteException;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.IdmPersonServiceException;
import gov.va.med.cds.idm.client.webservice.PSIMWebServicePort;

public class IdmPersonServiceDelegate implements IdmPersonServiceInterface {
	
	private PSIMWebServicePort idmService;

	public void setIdmService(PSIMWebServicePort idmService) {
		this.idmService = idmService;
	}

	public String execute(String requestXML) {
		try {
			return idmService.execute(requestXML);
		} catch (RemoteException e) {
			throw new IdmPersonServiceException(
					ErrorCodeEnum.IDM_SERVICE_EXCEPTION, e.getMessage());
		}
	}

	public String getAuditResult(String requestXML) {
		try {
			return idmService.getAuditResult(requestXML);
		} catch (RemoteException e) {
			throw new IdmPersonServiceException(
					ErrorCodeEnum.IDM_SERVICE_EXCEPTION, e.getMessage());
		}
	}

	public String getCorrespondingIds(String vpidstr) {
		try {
			return idmService.getCorrespondingIds(vpidstr);
		} catch (RemoteException e) {
			throw new IdmPersonServiceException(
					ErrorCodeEnum.IDM_SERVICE_EXCEPTION, e.getMessage());
		}
	}

	public String searchIdentity(String searchXML) {
		try {
			return idmService.searchIdentity(searchXML);
		} catch (RemoteException e) {
			throw new IdmPersonServiceException(
					ErrorCodeEnum.IDM_SERVICE_EXCEPTION, e.getMessage());
		}
	}

	@Override
	public void setTimeoutSeconds(String timeoutSeconds) {
		// no-op - timeout is set on port when it is created by the factory
	}
}
