

package gov.va.med.cds.hapi.extension.type;


import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.log.HapiLogFactory;


public class QIP
    extends
        AbstractType
    implements
        Composite
{
    private Type data[];

    private static final long serialVersionUID = 1L;


    public QIP( Message message )
    {
        super( message );
        data = new Type[2];
        data[0] = new ST( message );
        data[1] = new gov.va.med.cds.hapi.extension.type.Custom_SPR_ST( message );
    }


    public Type[] getComponents( )
    {
        return data;
    }


    public Type getComponent( int i )
        throws DataTypeException
    {
        try
        {
            return data[i];
        }
        catch ( ArrayIndexOutOfBoundsException arrayindexoutofboundsexception )
        {
            throw new DataTypeException( "Element " + i + " doesn't exist in 2 element QIP composite" );
        }
    }


    public ST getSegmentFieldName( )
    {
        ST st = null;
        try
        {
            st = ( ST )getComponent( 0 );
        }
        catch ( DataTypeException datatypeexception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected problem accessing known data type component - this is a bug.",
                            datatypeexception );
            throw new RuntimeException( datatypeexception );
        }
        return st;
    }


    public ST getValue1Value2Value3( )
    {
        ST st = null;
        try
        {
            st = ( ST )getComponent( 1 );
        }
        catch ( DataTypeException datatypeexception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected problem accessing known data type component - this is a bug.",
                            datatypeexception );
            throw new RuntimeException( datatypeexception );
        }
        return st;
    }

}
