

package gov.va.med.cds.hapi.extension.message;


import gov.va.med.cds.hapi.extension.CustomRequestHl7ModelClassFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.segment.DSC;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.RDF;
import ca.uhn.hl7v2.model.v231.segment.SPR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;


public class SPQ_Q08
    extends
        AbstractMessage
{
    public SPQ_Q08( ModelClassFactory modelclassfactory )
    {
        super( modelclassfactory );
        init( modelclassfactory );
    }


    public SPQ_Q08( )
    {
        super( new CustomRequestHl7ModelClassFactory() );
        init( new CustomRequestHl7ModelClassFactory() );
    }


    private void init( ModelClassFactory modelclassfactory )
    {
        try
        {
            add( ca.uhn.hl7v2.model.v231.segment.MSH.class, true, false );
            add( gov.va.med.cds.hapi.extension.segment.SPR.class, true, false );
            add( ca.uhn.hl7v2.model.v231.segment.RDF.class, false, false );
            add( ca.uhn.hl7v2.model.v231.segment.DSC.class, false, false );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error(
                            "Unexpected error creating SPQ_Q08 - this is probably a bug in the source code generator.", hl7exception );
        }
    }


    public MSH getMSH( )
    {
        MSH msh = null;
        try
        {
            msh = ( MSH )get( "MSH" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return msh;
    }


    public SPR getSPR( )
    {
        SPR spr = null;
        try
        {
            spr = ( SPR )get( "SPR" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return spr;
    }


    public RDF getRDF( )
    {
        RDF rdf = null;
        try
        {
            rdf = ( RDF )get( "RDF" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return rdf;
    }


    public DSC getDSC( )
    {
        DSC dsc = null;
        try
        {
            dsc = ( DSC )get( "DSC" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return dsc;
    }
}
