

package gov.va.med.cds.hapi.extension.message;


import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v21.segment.NTE;
import ca.uhn.hl7v2.model.v21.segment.PID;
import ca.uhn.hl7v2.model.v21.segment.PV1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;


public class ORU_R01_PATIENT
    extends
        AbstractGroup
{

    public ORU_R01_PATIENT( Group group, ModelClassFactory modelclassfactory )
    {
        super( group, modelclassfactory );
        try
        {
            add( ca.uhn.hl7v2.model.v24.segment.PID.class, true, false );
            add( ca.uhn.hl7v2.model.v24.segment.NTE.class, false, true );
            add( ca.uhn.hl7v2.model.v24.segment.PV1.class, false, false );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error(
                            "Unexpected error creating ORU_R01_PATIENT - this is probably a bug in the source code generator.", hl7exception );
        }
    }


    public PID getPID( )
    {
        PID pid = null;
        try
        {
            pid = ( PID )get( "PID" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return pid;
    }


    public NTE getNTE( )
    {
        NTE nte = null;
        try
        {
            nte = ( NTE )get( "NTE" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return nte;
    }


    public NTE getNTE( int i )
        throws HL7Exception
    {
        return ( NTE )get( "NTE", i );
    }


    public int getNTEReps( )
    {
        int i = -1;
        try
        {
            i = getAll( "NTE" ).length;
        }
        catch ( HL7Exception hl7exception )
        {
            String s = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog( getClass() ).error( s, hl7exception );
            throw new RuntimeException( s );
        }
        return i;
    }


    public PV1 getPV1( )
    {
        PV1 pv1 = null;
        try
        {
            pv1 = ( PV1 )get( "PV1" );
        }
        catch ( HL7Exception hl7exception )
        {
            HapiLogFactory.getHapiLog( getClass() ).error( "Unexpected error accessing data - this is probably a bug in the source code generator.",
                            hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return pv1;
    }
}
