

package gov.va.med.cds.hapi.extension;


import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;


/***********************************************************************************************************************
 * LabModelClassFactory is a custom ModelClassFactory used to lookup custom messages and segments. HAPI does not have
 * direct access to Segment classes, but they have direct access to Message classes. Hence any custom Segment will need
 * to be accessed through a Message class.
 * 
 */
public class LabModelClassFactory
    extends
        DefaultModelClassFactory
{
    /**
     * 
     */
    private static final long serialVersionUID = 939660732915725533L;


    /*
     * 
     * @see ca.uhn.hl7v2.parser.DefaultModelClassFactory#getMessageClass(java.lang.String, java.lang.String, boolean)
     */
    public Class getMessageClass( String theName, String theVersion, boolean isExplicit )
        throws HL7Exception
    {
        if ( theName.equals( "ORU_R01" ) )
            try
            {
                return Class.forName( "gov.va.med.cds.custom.message.ORU_R01" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        return super.getMessageClass( theName, theVersion, isExplicit );
    }

}
