/**
 * 
 */


package gov.va.med.cds.hapi.extension;


import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.impl.NoValidation;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;


/**
 * @author vhaislegberb
 * 
 */
public class CustomUnformattedXmlParser
    extends
        DefaultXMLParser
{
    public CustomUnformattedXmlParser( )
    {
        this( new CustomCdsModelClassFactory() );
    }


    public CustomUnformattedXmlParser( DefaultModelClassFactory modelClassFactory )
    {

        setModelClassFactory( modelClassFactory );
        setMessageValidator( new CDSCustomValidator( new NoValidation(), false ) );
    }


    public void setModelClassFactory( DefaultModelClassFactory modelClassFactory )
    {
        try
        {
            // because the property is hidden, use reflection to set the model
            // class factory for the parser.
            Field modelFactoryField = Parser.class.getDeclaredField( "myFactory" );
            modelFactoryField.setAccessible( true );
            modelFactoryField.set( this, modelClassFactory );
        }
        catch ( Exception e )
        {
            // not expected, but if it happens throw a runtime exception because
            // something is
            // seriously messed up.
            throw new UnsupportedOperationException( "myFactory property is not accessible.", e );
        }
    }


    public void setMessageValidator( MessageValidator messageValidator )
    {
        try
        {
            // because the property is hidden, use reflection to set the message validator for the parser.
            Field modelFactoryField = Parser.class.getDeclaredField( "myValidator" );
            modelFactoryField.setAccessible( true );
            modelFactoryField.set( this, messageValidator );
        }
        catch ( Exception e )
        {
            // not expected, but if it happens throw a runtime exception because
            // something is
            // seriously messed up.
            throw new UnsupportedOperationException( "myFactory property is not accessible.", e );
        }
    }


    protected String doEncode( Message source )
        throws HL7Exception
    {
        if ( source instanceof GenericMessage )
            throw new HL7Exception( "Can't XML-encode a GenericMessage.  Message must have a recognized structure." );
        Document doc = encodeDocument( source );
        doc.getDocumentElement().setAttribute( "xmlns", "urn:hl7-org:v2xml" );
        StringWriter out = new StringWriter();
        OutputFormat outputFormat = new OutputFormat( "", null, false );
        outputFormat.setPreserveSpace( true );
        XMLSerializer ser = new XMLSerializer( out, outputFormat );
        setKeepAsOriginalNodes( new String[] { "OBX.5", "RXE.21" } );
        try
        {
            ser.serialize( doc );
        }
        catch ( IOException e )
        {
            throw new HL7Exception( "IOException serializing XML document to string", 207, e );
        }
        return out.toString();
    }


    public String getEncoding( String message )
    {
        String encoding = null;

        // check for a number of expected strings
        String[] expected = { "<BHS", "<MSH.1", "<MSH.2", "</MSH>" };
        boolean isXML = true;
        for ( int i = 0; i < expected.length; i++ )
        {
            if ( message.indexOf( expected[i] ) < 0 )
            {
                isXML = true;
                break;
            }
            isXML = false;
        }
        if ( isXML )
            encoding = "XML";

        return encoding;
    }


    public String getVersion( String message )
        throws HL7Exception
    {

        if ( message.contains( "<BHS" ) )
        {
            return "2.4";
        }

        return super.getVersion( message );
    }
}
