

package gov.va.med.cds.hapi.extension;


import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;


public class CDSCustomValidator
    extends
        MessageValidator
{
    private static HapiLog ourLog = HapiLogFactory.getHapiLog( MessageValidator.class );

    private ValidationContext myContext;
    private boolean failOnError;


    /**
     * @param theContext context that determines which validation rules apply
     * @param theFailOnErrorFlag
     */
    public CDSCustomValidator( ValidationContext theContext, boolean theFailOnErrorFlag )
    {
        super( theContext, theFailOnErrorFlag );
        myContext = theContext;
        failOnError = theFailOnErrorFlag;
    }


    /**
     * @param message a parsed message to validate (note that MSH-9-1 and MSH-9-2 must be valued)
     * @return true if the message is OK
     * @throws HL7Exception if there is at least one error and this validator is set to fail on errors
     */
    public boolean validate( Message message )
        throws HL7Exception
    {

        try
        {
            if ( message.get( "BHS" ) != null )
            {
                return true;
            }
        }
        catch ( HL7Exception e )
        {
            // We expect this when we're not validating batch messages
        }
        return super.validate( message );
    }
}
