<?xml version="1.0"?> 
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:results="Results" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:map="map:java.util.Map" 
	xmlns:clinicaldata="Clinicaldata"
	exclude-result-prefixes="fn xs xsi xsl map results clinicaldata">
	<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="no"/>
		
	<xsl:template match="/clinicaldata:ClinicalData">{"nonVaMedicationEvents": { "nonVaMedicationEvent":[
		<xsl:for-each select="./patients/patient/nonVaMedicationEvents/nonVaMedicationEvent">
		{<xsl:call-template name="nonVaMedicationEventTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
		</xsl:for-each>
		<xsl:if test="count(./patients/patient/nonVaMedicationEvents/nonVaMedicationEvent) > 0 and count(./errorSection) = 1">,</xsl:if>
		<xsl:if test="count(./errorSection) = 1">
			<xsl:call-template name="errorSectionTemplate"/>
		</xsl:if>]}}
	</xsl:template>
	
		
	<xsl:template name="nonVaMedicationEventTemplate">
			"recordIdentifier":"<xsl:value-of select="recordIdentifier/identity"/>",
			"pharmacyPatient":{
				"identifier":{
					"identity":"<xsl:value-of select="pharmacyPatient/identifier/identity"/>",
					"assigingingFacility":"<xsl:value-of select="pharmacyPatient/identifier/assigningFacility"/>",
					"assigningAuthority":"<xsl:value-of select="pharmacyPatient/identifier/assigningAuthority"/>"
				} ,
				"name":{
					<xsl:if test="pharmacyPatient/name/prefix != ''">"prefix":"<xsl:value-of select="pharmacyPatient/name/prefix"/>",</xsl:if>
					<xsl:if test="pharmacyPatient/name/given != ''">"given":"<xsl:value-of select="pharmacyPatient/name/given"/>",</xsl:if>
					<xsl:if test="pharmacyPatient/name/middle != ''">"middle":"<xsl:value-of select="pharmacyPatient/name/middle"/>",</xsl:if>
					<xsl:if test="pharmacyPatient/name/family != ''">"family":"<xsl:value-of select="pharmacyPatient/name/family"/>",</xsl:if>
					<xsl:if test="pharmacyPatient/name/suffix != ''">"suffix":"<xsl:value-of select="pharmacyPatient/name/suffix"/>",</xsl:if>
					<xsl:if test="pharmacyPatient/name/title != ''">"title":"<xsl:value-of select="pharmacyPatient/name/title"/>"</xsl:if>
				},
			},
			"dosage":"<xsl:value-of select="dosage/value"/>",
			"schedule":"<xsl:value-of select="schedule/displayText"/>",
			"status":"<xsl:value-of select="status/displayText"/>",
			"medication":{
				"medicationName":"<xsl:value-of select="medication/medicationCode/displayText"/>",
				"genericMedicationName":"<xsl:value-of select="medication/medicationCode/alternateDisplayText"/>"
			},
			"medicationForm":"<xsl:value-of select="pharmacyOrderableItem/dosageFormCode/displayText"/>"
	</xsl:template>
		
	<xsl:template name="errorSectionTemplate">{ "errorSection":{
			<xsl:if test="count(./errorSection/errors/error) >= 1">"errors":{
				<xsl:for-each select="./errorSection/errors/error">"error":{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>}<xsl:if test="count(./errorSection/fatalErros/fatalError) + count(./errorSection/warnings/warning) &gt; 0">,</xsl:if>
			</xsl:if>
			<xsl:if test="count(./errorSection/fatalErrors/fatalError) >= 1">"fatalErrors":{
				<xsl:for-each select="./errorSection/fatalErrors/fatalError">"fatalError":{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>}<xsl:if test="count(./errorSection/warnings/warning) &gt; 0">,</xsl:if>
			</xsl:if>
			<xsl:if test="count(./errorSection/warnings/warning) >= 1">"warnings":{
				<xsl:for-each select="./errorSection/warnings/warning">"warning":{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>}
			</xsl:if>}}
	</xsl:template>	
	
	<xsl:template name="exceptionTemplate">
		"exceptionMessage":"<xsl:value-of select="exceptionMessage"/>",
		"displayMessage":"<xsl:value-of select="displayMessage"/>",
		"exception":"<xsl:value-of select="exception"/>",
		"errorCode":"<xsl:value-of select="errorCode"/>",
		"errorId":"<xsl:value-of select="errorId"/>"
	</xsl:template>
	
</xsl:stylesheet>
