<?xml version="1.0"?> 
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:results="Results" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:map="map:java.util.Map" 
	xmlns:clinicaldata="Clinicaldata"
	exclude-result-prefixes="fn xs xsi xsl map results clinicaldata">
	<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="no"/>
		
	
	<xsl:template match="/nonVaMedicationEvent">
		<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="NonVAMedicationCreateOrUpdate3.xsd">
			<clientName>
				<xsl:value-of select="clientName"/>
			</clientName>
			<clientRequestInitiationTime>
				<xsl:value-of select="clientRequestInitiationTime"/>
			</clientRequestInitiationTime>
			<templateId>NonVAMedicationCreateOrUpdate3</templateId>			
			<patient>
				<nonVaMedicationEvent>
					<pharmacyPatient>
						<identifier>
							<identity>
								<xsl:value-of select="pharmacyPatientId/identity"/>
							</identity>
							<assigningFacility>
								<xsl:value-of select="pharmacyPatientId/assigningFacility"/>
							</assigningFacility>
							<assigningAuthority>
								<xsl:value-of select="pharmacyPatientId/assigningAuthority"/>
							</assigningAuthority>
						</identifier>
						<name>
							<prefix>
								<xsl:value-of select="pharmacyPatientName/prefix"/>
							</prefix>
							<given>
								<xsl:value-of select="pharmacyPatientName/given"/>
							</given>
							<middle>
								<xsl:value-of select="pharmacyPatientName/middle"/>
							</middle>							
							<family>
								<xsl:value-of select="pharmacyPatientName/family"/>
							</family>
							<suffix>
								<xsl:value-of select="pharmacyPatientName/suffix"/>
							</suffix>
							<title>
								<xsl:value-of select="pharmacyPatientName/title"/>
							</title>	
						</name>			
					</pharmacyPatient>
					<dosage>
						<value> 
							<xsl:value-of select="dosage"/>
						</value>
					</dosage>			
					<schedule>
						<displayText>
							<xsl:value-of select="schedule"/>
						</displayText>
					</schedule>
					<status>
						<displayText>
							<xsl:value-of select="status"/>
						</displayText>
					</status>			
					<medication>
						<medicationCode>
							<displayText>
								<xsl:value-of select="medication/medicationName"/>
							</displayText>
							<alternateDisplayText>
								<xsl:value-of select="medication/genericMedicationName"/>
							</alternateDisplayText>
						</medicationCode>
					</medication>
					<pharmacyOrderableItem>
						<dosageFormCode>
							<displayText>
								<xsl:value-of select="medicationForm"/>
							</displayText>
						</dosageFormCode>
					</pharmacyOrderableItem>
				</nonVaMedicationEvent>
			</patient>
		</clinicaldata:ClinicalData>
	</xsl:template>
</xsl:stylesheet>
