<?xml version="1.0"?> 
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:filter="Filter" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:map="map:java.util.Map" 
	exclude-result-prefixes="fn xs xsi xsl map">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	
	<xsl:template match="/requestData">
		<filter:filter vhimVersion="Vhim_4_00" xmlns:filter="Filter">
			<filterId>
				<xsl:value-of select="filterId"/>
			</filterId>
			<clientName>
				<xsl:value-of select="clientName"/>
			</clientName>
			<clientRequestInitiationTime>
					<xsl:if test="clientRequestInitiationTime != ''">
						<xsl:value-of select="clientRequestInitiationTime"/>
					</xsl:if>
					<xsl:if test="clientRequestInitiationTime = ''">
						<xsl:value-of select="current-dateTime()"/>
					</xsl:if>
					<xsl:if test="not(clientRequestInitiationTime)">
						<xsl:value-of select="current-dateTime()"/>
					</xsl:if>			
			</clientRequestInitiationTime>
			<entryPointFilter queryName="queryName" isPatientCentric="false">
				<domainEntryPoint>
					<xsl:value-of select="domainEntryPoint"/>
				</domainEntryPoint>
				<recordIdentifiers>
					<identity><xsl:value-of select="recordIdentifier"/></identity>
				</recordIdentifiers>
			</entryPointFilter>	
		</filter:filter>
	</xsl:template>
</xsl:stylesheet>
