/**
 * 
 */
package gov.va.med.repositories.fpds.validator;

import java.util.List;

import javax.ws.rs.ValidationError;
import javax.ws.rs.core.MultivaluedMap;

/**
 * @author vhaislegberb
 * 
 * Interface that FPRS service used to interact with specific validator implementations.
 *
 */
public interface Validator
{
    List<ValidationError> validateRequestParameters(String templateId, String filterId, String domain, MultivaluedMap<String, String> queryParameters);
    List<ValidationError> validateRequestParameters( String templateId, String request, MultivaluedMap<String, String> queryParameters );
    List<ValidationError> constructValidationError(String param, String message);
    boolean isPatientCentric(String filterId);
}
