/**
* 
*/


package gov.va.med.repositories.fpds.validator;


import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.ValidationError;
import javax.ws.rs.core.MultivaluedMap;

import org.springframework.util.StringUtils;


/**
 * @author vhaislegberb
 *
 */
public class DefaultRequestValidator
    implements
        Validator
{
    public static final String REQUEST_ID = "requestId";
    public static final String CLIENT_NAME = "clientName";
    public static final String EX_AF = "excludedAssigningFacility";
    public static final String EX_AA = "excludedAssigningAuthority";
    public static final String EX_AI = "excludedIdentifier";
    public static final String RS_AF = "resolvedAssigningFacility";
    public static final String RS_AA = "resolvedAssigningAuthority";
    //public static final String RS_AI = "resolvedIdentifier";
    public static final String RS_AI = "identifier";
    private static final String TYPE = "_type";
    private static final String XML_REQUEST = "<clinicaldata:ClinicalData";
    private static final String XML_RESPONSE_TYPE = "xml";
    private static final String DEFAULT_RESPONSE_TYPE = "json";
    private static final String DEFAULT_REQUEST = "{";
    

    @Override
    /*
     * (non-Javadoc)
     * @see gov.va.med.repositories.fprs.validator.ValidatorInterface#validateRequestParameters(java.lang.String, java.lang.String, java.lang.String, javax.ws.rs.core.MultivaluedMap)
     */
    public List<ValidationError> validateRequestParameters( String templateId, String filterId, String domain,
                    MultivaluedMap<String, String> queryParameters )
    {
        List<ValidationError> validationErrors = new ArrayList<ValidationError>();

        for ( String key : queryParameters.keySet() )
        {
            if ( !StringUtils.hasText( key ) )
            {
                validationErrors.add( new InvalidParameterValidationError( "Invalid Key", "Query Parameter key is empty." ) );
            }
            else
            {
                final List<String> values = queryParameters.get( key );
                if ( values == null || values.size() != 1 || !StringUtils.hasText( values.get( 0 ) ) )
                {
                    validationErrors.add( new InvalidParameterValidationError( values, String.format(
                                    "Query parameter %s must have a single, non-empty string value.", key ) ) );
                }
            }
        }

        String responseType = queryParameters.getFirst( TYPE );

        if ( !StringUtils.hasText( responseType ) )
        {
            responseType = "json";
            //queryParameters.add( TYPE, "json" );
        }

        if ( !responseType.equals( "xml" ) && !responseType.equals( "json" ) )
        {
            validationErrors.add( new InvalidParameterValidationError( TYPE, "Response type can only be XML or JSON" ) );
        }

        String requestId = queryParameters.getFirst( REQUEST_ID );

        if ( !StringUtils.hasText( requestId ) )
        {
            validationErrors.add( new InvalidParameterValidationError( requestId, "Request parameter requestId was not provided or was empty." ) );
        }

        String clientName = queryParameters.getFirst( CLIENT_NAME );
        if ( !StringUtils.hasText( clientName ) )
        {
            validationErrors.add( new InvalidParameterValidationError( CLIENT_NAME, String.format(
                            "Request parameter %s was not provided or was empty.", CLIENT_NAME ) ) );
        }

        String exAssigningFacility = queryParameters.getFirst( EX_AF );
        String exAssigningAuthority = queryParameters.getFirst( EX_AA );
        String exIdentity = queryParameters.getFirst( EX_AI );

        if ( StringUtils.hasText( exIdentity ) && ( !StringUtils.hasText( exAssigningAuthority ) || !StringUtils.hasText( exAssigningFacility ) ) )
        {
            validationErrors.add( new InvalidParameterValidationError( EX_AI,
                            "Excluded facility and assigning authority are required if excluded identity is provided." ) );
        }
        else if ( ( StringUtils.hasText( exAssigningAuthority ) && !StringUtils.hasText( exAssigningFacility ) )
                        || ( !StringUtils.hasText( exAssigningAuthority ) && StringUtils.hasText( exAssigningFacility ) ) )
        {
            validationErrors.add( new InvalidParameterValidationError( EX_AI,
                            "If either of excluded assigning authority or facility is provided, both must be provided." ) );
        }
        
        if(isPatientCentric(filterId))
        {
        	
        	String rsAssigningFacility = queryParameters.getFirst( RS_AF );
        	String rsAssigningAuthority = queryParameters.getFirst( RS_AA );
        	String rsIdentity = queryParameters.getFirst( RS_AI );

        	if ( StringUtils.hasText( rsIdentity ) && ( !StringUtils.hasText( rsAssigningAuthority ) || !StringUtils.hasText( rsAssigningFacility ) ) )
        	{
        		validationErrors.add( new InvalidParameterValidationError( RS_AI,
                            "Resolved facility and assigning authority are required if resolved identity is provided." ) );
        	}
        	else if ( ( StringUtils.hasText( rsAssigningAuthority ) && !StringUtils.hasText( rsAssigningFacility ) )
                        || ( !StringUtils.hasText( rsAssigningAuthority ) && StringUtils.hasText( rsAssigningFacility ) ) )
        	{
        		validationErrors.add( new InvalidParameterValidationError( RS_AI,
                            "If either resolved assigning authority or facility is provided, both must be provided." ) );
        	}
        }

        return validationErrors;
    }

    private class InvalidParameterValidationError
        implements
            ValidationError
    {
        private Object invalidValue;

        private String message;


        public InvalidParameterValidationError( Object invalidValue, String message )
        {
            this.invalidValue = invalidValue;
            this.message = message;
        }


        @Override
        public Object getInvalidValue( )
        {
            return this.invalidValue;
        }


        @Override
        public String getMessage( )
        {
            return this.message;
        }
    }


    @Override
    /*
     * (non-Javadoc)
     * @see gov.va.med.repositories.fprs.validator.ValidatorInterface#validateRequestParameters(java.lang.String, java.lang.String, java.lang.String, javax.ws.rs.core.MultivaluedMap)
     */
    public List<ValidationError> validateRequestParameters( String templateId, String request, MultivaluedMap<String, String> queryParameters )
    {

        List<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String responseType = null;

        List<String> typeList = ( List<String> )queryParameters.get( "_type" );

        if ( typeList != null )
        {
            responseType = ( String )typeList.get( 0 );
            if ( !responseType.equals( XML_RESPONSE_TYPE) && !responseType.equals( DEFAULT_RESPONSE_TYPE ) )
            {
                validationErrors.add( new InvalidParameterValidationError( TYPE, "Response type can only be XML or JSON" ) );
            }

            if ( request.contains( XML_REQUEST ) && responseType.equals( DEFAULT_RESPONSE_TYPE ) )
            {
                validationErrors.add( new InvalidParameterValidationError( request, String.format( "XML request with wrong type - %s is sent.",
                                responseType ) ) );
            }
            else if ( request.contains( DEFAULT_REQUEST ) && responseType.equals( XML_RESPONSE_TYPE ) )
            {
                validationErrors.add( new InvalidParameterValidationError( request, String.format( "Json request with wrong type - %s is sent.",
                                responseType ) ) );
            }
        }
       

        return validationErrors;
    }
    
    public List<ValidationError> constructValidationError(String param, String message){
    	List<ValidationError> errors = new ArrayList<ValidationError>();
    	errors.add(new InvalidParameterValidationError( param, message)); 
    	return errors;
    }

	@Override
	public boolean isPatientCentric(String filterId) {
		boolean patientCentric = true; 
		if(!filterId.contains( "PATIENT"))
         {
         	patientCentric=false;
         }
		return patientCentric;
	}

}
