

package gov.va.med.repositories.fpds.template;


import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

import net.sf.saxon.TransformerFactoryImpl;

import org.dom4j.io.DocumentResult;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.InputSource;


public class RequestXsltTemplateBuilder
    implements
        TemplateBuilder
{
    private Map<String, String> templateXsltMap;
    private Map<String, Templates> transformersMap;


    public String createTemplate( String request, String templateId )
    {

        Transformer transformer = null;
        DocumentResult result = new DocumentResult();

        if ( transformersMap == null || transformersMap.isEmpty() )
        {
            throw new TemplateBuilderException( "This template build requires an XSLT style-sheet in order to build the template."
                            + " Make sure to set the template transformer template resource location before calling the createTemplate method." );
        }

        try
        {
            transformer = transformersMap.get( templateId ).newTransformer();

            transformer.transform( new SAXSource( new InputSource( new StringReader( request ) ) ), result );

        }
        catch ( Exception e )
        {
            throw new TemplateBuilderException( "Error transforming JSON xml to VHIM XML.", e );
        }

        return result.getDocument().asXML();
    }


    public void setTemplateXsltMap( Map<String, String> templateXsltMap )
        throws TransformerConfigurationException,
            IOException
    {
        this.templateXsltMap = templateXsltMap;

        String templateId = null;
        String xsltTemplate = null;
        transformersMap = new HashMap<String, Templates>();
        for ( Map.Entry<String, String> entry : templateXsltMap.entrySet() )
        {

            templateId = entry.getKey();
            xsltTemplate = entry.getValue();

            org.springframework.core.io.Resource templateResource = new ClassPathResource( xsltTemplate );
            InputStream templateInputStream = templateResource.getInputStream();
            StreamSource templateStreamSource = new StreamSource( templateInputStream );

            transformersMap.put( templateId, new TransformerFactoryImpl().newTemplates( templateStreamSource ) );
        }

    }

}
