/**
 * 
 */
package gov.va.med.repositories.fpds.filter;

import javax.ws.rs.core.MultivaluedMap;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.util.StringUtils;

/**
 * @author vhaislegberb
 *
 * This class uses an XSLT style-sheet to generate the filter from the incoming request.
 */
public class HmpReadRequestXsltFilterBuilder extends AbstractBaseFilterBuilder
{
  
     Document buildRequestParamsDocument( String filter, String domain, String patient, MultivaluedMap<String, String> additionalParams )
    {
    	Document filterDocument = DocumentHelper.createDocument( DocumentHelper.createElement( "requestData" ) );
        filterDocument.getRootElement().add( DocumentHelper.createElement( "filterId" ).addText( filter ) );
        filterDocument.getRootElement().add( DocumentHelper.createElement( "patientId" ).addText( patient) );
        filterDocument.getRootElement().add(DocumentHelper.createElement( "additionalParams" ));
        filterDocument.getRootElement().element( "additionalParams" ).add( DocumentHelper.createElement( "entry" ).addAttribute( "key", "domain" )
                        .addAttribute( "value", domain ) );
        
        for(String key : additionalParams.keySet())
        {
            if(  StringUtils.hasLength( additionalParams.getFirst( key ) ) )
            {
                if(!key.startsWith( "_" )) // ignore any query parameters that start with an underscore character.
                {
                    if(STANDARD_FILTER_PARAMS.contains( key ))
                    {
                        filterDocument.getRootElement().add( DocumentHelper.createElement( key ).addText( additionalParams.getFirst( key ) ) );
                    }
                    else
                    {
                        filterDocument.getRootElement().element( "additionalParams" ).add( DocumentHelper.createElement( "entry" ).addAttribute( "key", key )
                                        .addAttribute( "value", additionalParams.getFirst(key) ) );
                    }
                }
            }
        }
        
        return filterDocument;
    }
}
