

package gov.va.med.repositories.fpds.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.testharness.AbstractBaseTest;

import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.test.context.ContextConfiguration;

import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.TextMessageImpl;


//@RunWith( SuiteAwareSpringRunner.class )
//@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/logAndSwallowAspectContext.xml" } )
public class FpdsCreateMessageRequestMdbTest
    extends
        AbstractBaseTest
{
    private static String TEMPLATE_ID = "TEMPLATE_ID";
    private static String REQUEST_ID = "REQUEST_ID";
    private static String SENDING_FACILITY = "SENDING_FACILITY";
    private static String SENDING_APPLICATION = "SENDING_APPLICATION";
    private static String MESSAGE_DATE_TIME = "MESSAGE_DATE_TIME";
   
    private static String UNIQUE_ID="UNIQUE_ID";
    private static String CLIENT_INITIATION_TIME="CLIENT_INITIATION_TIME";
    private static String CLIENT_NAME = "CLIENT_NAME ";
    private static String PATIENT_IDENTITY ="PATIENT_IDENTITY";
    private static String PATIENT_ASSIGNING_FACILITY = "RESPONSE_WITH_SCHEMA_VALIDATION_FAILED";
    private static String PATIENT_ASSIGNING_AUTHORITY = "PATIENT_ASSIGNING_AUTHORITY";
    private static String COLLECTION_TYPE = "COLLECTION_TYPE";
    
    private static String RESPONSE_WITH_NO_ERROR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>AllergyAssessmentCreate40020</templateId><requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId><errorSection/></clinicaldata:ClinicalData>";
    private static String RESPONSE_WITH_UNIQUE_CONSTRAINT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>AllergyAssessmentCreate40020</templateId><requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId><errorSection><fatalErrors><errorId>55253592077</errorId><exception>gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException</exception><exceptionMessage>HDRII_CONSTRAINT_VIOLATED</exceptionMessage><errorCode>HDRII_CONSTRAINT_VIOLATED</errorCode><displayMessage>HDR2 Integrity constraint violated:BaseBatchUpdateException: [BEA][Oracle JDBCDriver][Oracle]ORA-00001: unique constraint(ALLERGIES.ALLERGY_RECORDID_UNQ_CK) violated</displayMessage></fatalErrors></errorSection></clinicaldata:ClinicalData>";
    private static String RESPONSE_WITH_SCHEMA_VALIDATION_FAILED = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>VitalsignsCreateOrUpdate40060</templateId><requestId>5A2B3C920D5F3</requestId><errorSection><fatalErrors><errorId>5A2B3C920D5F3</errorId><exception>gov.va.med.cds.xml.schema.SchemaValidationException</exception><exceptionMessage>SCHEMA_VALIDATION_FAILED</exceptionMessage><errorCode>SCHEMA_VALIDATION_FAILED</errorCode><displayMessage>Schema validation failed because of cvc-complex-type.2.4.a: Invalid content was found starting with element 'patient'. One of '{&quot;&quot;:recordIdentifier}' is expected.</displayMessage></fatalErrors></errorSection></clinicaldata:ClinicalData>";

    // injected by Spring
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;


   // @Test
   // @Suite( groups = "checkintest" )
    public void testSetMessageDrivenContext()
    {
    	MessageDrivenContext messageDrivenContext = EasyMock.createMock(MessageDrivenContext.class);
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();
        fpdsMessageRequestMdb.setMessageDrivenContext(messageDrivenContext);
    }
    
   // @Test
   // @Suite( groups = "brokentest" )
    public void testOnMessageWithBytesMessage( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        BytesMessage message = new BytesMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "PGDCreateOrUpdate1");
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( UNIQUE_ID, "239283938298320" );
        message.setStringProperty( CLIENT_INITIATION_TIME, "2014-06-06t09:307Z" );
        message.setStringProperty( CLIENT_NAME, "HMPPGD" );
        
        message.setStringProperty( PATIENT_IDENTITY, "987654321XXX");
        message.setStringProperty( PATIENT_ASSIGNING_FACILITY, "200HMP");
        message.setStringProperty( PATIENT_ASSIGNING_AUTHORITY, "USVHA" );
        message.setStringProperty( COLLECTION_TYPE, "NONVAMEDS");
        
        message.writeBytes( "<VHIM Payload>".getBytes() );
        message.reset();
       

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "PGDCreateOrUpdate1", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_NO_ERROR );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );
        
    
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        fpdsMessageRequestMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( cdsServiceMock, responseJmsTemplateMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


    //@Test
    //@Suite( groups = "brokentest" )
    public void testOnMessageWithTextMessage( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "SERVER1.fieldoffice.DOMAIN.EXT" );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142030-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_NO_ERROR );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );

        //fpdsMessageRequestMdb.setPersistOriginalMessage( true );
     // fpdsMessageRequestMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        fpdsMessageRequestMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock, responseJmsTemplateMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


    //@Test( expected = RuntimeMDBOnMessageException.class )
    //@Suite( groups = "checkintest" )
    public void testOnMessageWithObjectMessage( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();
        fpdsMessageRequestMdb.setClinicalDataResponse(new ClinicalDataResponse400());
        
        ObjectMessage message = new ObjectMessageImpl();

        fpdsMessageRequestMdb.onMessage( message );
    }


    //@Test( expected = RuntimeException.class )
    //@Suite( groups = "checkintest" )
    public void testOnMessageThrowingRuntimeExceptionByAuditClobStore( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "TemplateId" );
        message.setStringProperty( REQUEST_ID, "RequestId" );
        message.setStringProperty( SENDING_FACILITY, "SendingFacility" );
        message.setStringProperty( SENDING_APPLICATION, "SendingApp" );
        message.setStringProperty( MESSAGE_DATE_TIME, "MessageDtTm" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( "DBQCreate1", EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "TemplateId", "RequestId" ) ).andReturn( RESPONSE_WITH_NO_ERROR );

        //fpdsMessageRequestMdb.setPersistOriginalMessage( true );
        //fpdsMessageRequestMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


    //@Test( expected = RuntimeException.class )
   // @Suite( groups = "checkintest" )
    public void testOnMessageThrowingRuntimeExceptionByCdsService( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "TemplateId" );
        message.setStringProperty( REQUEST_ID, "RequestId" );
        message.setStringProperty( SENDING_FACILITY, "SendingFacility" );
        message.setStringProperty( SENDING_APPLICATION, "SendingApp" );
        message.setStringProperty( MESSAGE_DATE_TIME, "MessageDtTm" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "TemplateId", "RequestId" ) ).andThrow( new RuntimeException() );

        //fpdsMessageRequestMdb.setPersistOriginalMessage( false );
        //fpdsMessageRequestMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


   // @Test
   // @Suite( groups = "brokentest" )
    public void testOnMessageWithUniqueConstraintExceptionThrownByCdsService( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "SERVER1.fieldoffice.DOMAIN.EXT" );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142030-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_UNIQUE_CONSTRAINT );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );

        //fpdsMessageRequestMdb.setPersistOriginalMessage( true );
       // fpdsMessageRequestMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        fpdsMessageRequestMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock, responseJmsTemplateMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


    //@Test( expected = RuntimeMDBOnMessageException.class )
    //@Suite( groups = "checkintest" )
    public void testOnMessageWithSchemaValidationExceptionThrownByCdsService( )
        throws Exception
    {
        FpdsCreateMessageRequestMdb fpdsMessageRequestMdb = new FpdsCreateMessageRequestMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "SERVER1.fieldoffice.DOMAIN.EXT" );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142030-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_SCHEMA_VALIDATION_FAILED );

        //fpdsMessageRequestMdb.setPersistOriginalMessage( true );
       // fpdsMessageRequestMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        fpdsMessageRequestMdb.setCdsService( cdsServiceMock );
        fpdsMessageRequestMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        fpdsMessageRequestMdb.onMessage( message );
    }


    @javax.annotation.Resource
    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }
}
