/**
 * 
 */
package gov.va.med.repositories.fpds.ejb;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.jms.JMSException;
import javax.jms.Message;

import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import org.apache.commons.lang.StringUtils;


public class FpdsCreateMessageRequestMdb
    extends
        AbstractFpdsMessageRequestMdb
{

	 private static String CLIENT_INITIATION_TIME = "CLIENT_INITIATION_TIME";
	 private static String RECORD_UPDATE_TIME = "RECORD_UPDATE_TIME";
	 private static String CLIENT_NAME = "CLIENT_NAME";
	 private static String PATIENT_IDENTITY = "PATIENT_IDENTITY";
	 private static String PATIENT_ASSIGNING_FACILITY = "PATIENT_ASSIGNING_FACILITY";
	 private static String PATIENT_ASSIGNING_AUTHORITY = "PATIENT_ASSIGNING_AUTHORITY";
	 private static String COLLECTION_TYPE = "COLLECTION_TYPE";
	 
	 private static final String DEFAULT_FACILITY = "200HMP";
	 private static final String DEFAULT_AUTHORITY = "USVHA";
	 

   /**
	 * 
	 */
	private static final long serialVersionUID = -5920439842937766711L;


    /* (non-Javadoc)
     * @see gov.va.med.repositories.fpds.ejb.AbstractFpdsMessageRequestMdb#doClinicalOperation(java.lang.String, java.lang.String, java.lang.String)
     */
    @Override
    protected String doClinicalOperation( String vhimPayload, String templateId, String requestId )
    {
        return this.cdsService.createClinicalData( vhimPayload, templateId, requestId );
    }


	@Override
	protected Map<String, String> getMessageProperties(Message message) throws JMSException {
		
		Map<String,String> messageProperties = new HashMap<String,String>(9);
	    
		String templateId = message.getStringProperty( TEMPLATE_ID );
		if(templateId==null){
			templateId=defaultCreateTemplateName;
		}
		String facility = message.getStringProperty( PATIENT_ASSIGNING_FACILITY );
		if(StringUtils.isEmpty(facility)){
			facility = DEFAULT_FACILITY;
		}
		String authority = message.getStringProperty( PATIENT_ASSIGNING_AUTHORITY);
		if(StringUtils.isEmpty(authority)){
			authority = DEFAULT_AUTHORITY;
		}
						
        messageProperties.put(TEMPLATE_ID,templateId ); 
        messageProperties.put(REQUEST_ID, message.getStringProperty( REQUEST_ID ));
        messageProperties.put(UNIQUE_ID, message.getStringProperty( UNIQUE_ID ));
        messageProperties.put(CLIENT_INITIATION_TIME, message.getStringProperty( CLIENT_INITIATION_TIME ));
        messageProperties.put(CLIENT_NAME,  message.getStringProperty( CLIENT_NAME ));
        messageProperties.put(PATIENT_IDENTITY, message.getStringProperty( PATIENT_IDENTITY ));
        messageProperties.put(PATIENT_ASSIGNING_FACILITY, facility);
        messageProperties.put(PATIENT_ASSIGNING_AUTHORITY,authority);
        messageProperties.put(COLLECTION_TYPE, message.getStringProperty( COLLECTION_TYPE ));
        String recordUpdateTime = message.getStringProperty( RECORD_UPDATE_TIME );
        if(recordUpdateTime != null){
        	messageProperties.put(RECORD_UPDATE_TIME, message.getStringProperty( RECORD_UPDATE_TIME ));
        }
        
		return messageProperties;
	}

	@Override
	protected String constructXmlMessagePayload(String messagePayload,
			Map<String, String> messageProperties) {
		
		Document document = this.clinicalDataResponse.buildEmptyClinicalDocument(messageProperties.get(TEMPLATE_ID), messageProperties.get(REQUEST_ID), messageProperties.get(CLIENT_NAME));
		this.clinicalDataResponse.getChildElement(document, "requestId").detach();
		if(!StringUtils.isEmpty(messageProperties.get(CLIENT_INITIATION_TIME)))
		{
			this.clinicalDataResponse.getChildElement(document, "clientRequestInitiationTime").setText(messageProperties.get(CLIENT_INITIATION_TIME));
		}
		
		Element clinicalPatient = this.clinicalDataResponse.getPatientElement(document);
		
		Element patient = DocumentHelper.createElement("patient");
		
		if(messageProperties.get(PATIENT_IDENTITY) !=null)
		{
			Element patientIdentifier = DocumentHelper.createElement("identifier");
			Element identity = DocumentHelper.createElement("identity");
			identity.setText(messageProperties.get(PATIENT_IDENTITY));
			Element assigningFacility = DocumentHelper.createElement("assigningFacility");
			assigningFacility.setText(messageProperties.get(PATIENT_ASSIGNING_FACILITY));
			Element assigningAuthority= DocumentHelper.createElement("assigningAuthority");
			assigningAuthority.setText(messageProperties.get(PATIENT_ASSIGNING_AUTHORITY));
		
			patientIdentifier.add(identity);
			patientIdentifier.add(assigningFacility);
			patientIdentifier.add(assigningAuthority);
			patient.add(patientIdentifier);
		}
		
		
		Element uniqueIdentifier = DocumentHelper.createElement("uniqueIdentifier");
		if(messageProperties.get(UNIQUE_ID)!=null)
		{
			Element uId = DocumentHelper.createElement("identity");
			uId.setText(messageProperties.get(UNIQUE_ID));
			uniqueIdentifier.add(uId);
		}
		
		Element patientGeneratedDataEvents = DocumentHelper.createElement("patientGeneratedDataEvents");
		Element patientGeneratedDataEvent = DocumentHelper.createElement("patientGeneratedDataEvent");
		Element collectionType = DocumentHelper.createElement("collectionType");
		if(messageProperties.get(COLLECTION_TYPE) !=null)
		{
			collectionType.setText(messageProperties.get(COLLECTION_TYPE));
		}
		
		Element pgdContent = DocumentHelper.createElement("pgdContent");
		pgdContent.add(DocumentHelper.createCDATA(messagePayload));
		
		patientGeneratedDataEvent.add(uniqueIdentifier);
		patientGeneratedDataEvent.add(patient);
		patientGeneratedDataEvent.add(collectionType);
		if(null != messageProperties.get( RECORD_UPDATE_TIME ))
		{
			Element recordUpdateTime = DocumentHelper.createElement("recordUpdateTime");
			Element literal = DocumentHelper.createElement("literal");
			literal.setText(messageProperties.get(RECORD_UPDATE_TIME));
			recordUpdateTime.add(literal);
			patientGeneratedDataEvent.add(recordUpdateTime);
		}
		patientGeneratedDataEvent.add(pgdContent);
		
		patientGeneratedDataEvents.add(patientGeneratedDataEvent);
		clinicalPatient.add(patientGeneratedDataEvents);
	
		return document.asXML();
	}


	@Override
	protected String transfromXmlMessageResponseToJson(
			String xmlMessageResponse, Map<String, String> messageProperties, boolean errorThrown){
				
		Map<String,Object>params=new HashMap<String,Object>();
		
		String status = "SUCCESS";
		if( checkForErrors(xmlMessageResponse) || errorThrown)
		{
			status = "FAILURE";
		}
		
		params.put("status", status);
		params.put("uId", messageProperties.get(UNIQUE_ID));
		params.put("requestId", messageProperties.get(REQUEST_ID));
		params.put("colType", messageProperties.get(COLLECTION_TYPE));
		params.put("patId", messageProperties.get(PATIENT_IDENTITY));
				
		String result = xsltHelper.transformMessageAsPlainText(xmlMessageResponse, defaultResponseTransform, params);
			 
		return result;
	}
	
}
