

package gov.va.med.repositories.fpds.ejb;


import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.RuntimeMDBOnMessageException;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.xml.transform.TransformerInterface;
import gov.va.med.repositories.fpds.ejb.config.BeanConstantsInterface;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Map;

import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractJmsMessageDrivenBean;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jndi.JndiTemplate;


public abstract class AbstractFpdsMessageRequestMdb
    extends
        AbstractJmsMessageDrivenBean
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 6708561887543396906L;
	protected static String TEMPLATE_ID = "TEMPLATE_ID";
	protected static String REQUEST_ID = "REQUEST_ID";
	protected static String UNIQUE_ID = "UNIQUE_ID";
	protected static String NO_REQUEST_ID_PROVIDED = "NO_REQUEST_ID";
        
	protected JndiTemplate jndiTemplate = new JndiTemplate();
    protected ClinicalDataServiceInterface cdsService;
    protected ResponseErrorSectionExtractor responseErrorSectionExtractor;
    
    protected JmsTemplate responseJmsTemplate;
    protected String fpdsAppName = BeanConstantsInterface.FPDS_APP_NAME ;
    protected ClinicalDataResponseInterface clinicalDataResponse;
    
    private static final String DEFAULT_TEMPLATE_ID = "PGDCreateOrUpdate1";
    private static final String DEFAULT_XSL_TRANSFORM = "CreateResponse-json.xsl";
    protected String defaultCreateTemplateName;
    protected String defaultResponseTransform;
    
    protected TransformerInterface xsltHelper;
    
   

    /* (non-Javadoc)
     * @see org.springframework.ejb.support.AbstractMessageDrivenBean#onEjbCreate()
     */
    @Override
    protected void onEjbCreate( )
    {
        try
        {
            cdsService = ( ClinicalDataServiceInterface )getBeanFactory().getBean( BeanConstantsInterface.CLINICAL_STATELESS_SESSION_ID );
            responseErrorSectionExtractor = ( ResponseErrorSectionExtractor )getBeanFactory().getBean( "responseErrorSectionExtractor" );
            responseJmsTemplate = (JmsTemplate)getBeanFactory().getBean(BeanConstantsInterface.ASYNC_RESPONSE_JMS_TEMPLATE);
            clinicalDataResponse = (ClinicalDataResponseInterface)getBeanFactory().getBean("clinicalDataResponse");
            xsltHelper = ( TransformerInterface )getBeanFactory().getBean( BeanConstantsInterface.XSLT_HELPER );
            defaultCreateTemplateName = ( String )safeGetEnvironmentEntry( "java:comp/env/ejb/defaultCreateTemplateName", String.class, DEFAULT_TEMPLATE_ID );
            defaultResponseTransform = ( String )safeGetEnvironmentEntry( "java:comp/env/ejb/defaultResponseTransform", String.class, DEFAULT_XSL_TRANSFORM );
        }
        catch ( Exception e )
        {
           //TODO should do something - CDS ignores this also ...
        }
    }
    
    @SuppressWarnings( "unchecked" )
    protected Object safeGetEnvironmentEntry(String name, @SuppressWarnings( "rawtypes" ) Class type, Object defaultValue)
    {
        Object environmentEntry = defaultValue;
        try {
            environmentEntry =  this.jndiTemplate.lookup( name, type );
        } catch (NamingException ne)
        {
            logger.warn( String.format( "Error initializing FPDS MDB. Error Reason: %s", ne.getMessage() ), ne );
        }
        
        return environmentEntry;
    }


    public void setMessageDrivenContext( MessageDrivenContext messageDrivenContext )
    {
        super.setMessageDrivenContext( messageDrivenContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance( "fpdsBeanRefContext.xml" ) );
        setBeanFactoryLocatorKey( ServiceConstantsInterface.PRIMARY_CONTEXT_ID );
    }


    /* (non-Javadoc)
     * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
     */
    public void onMessage( Message message )
    {
        String templateId = null;
        String requestId = null;
        String uId= null;
       
        String response = null;
        Map<String,String> messageProperties = null;
        
        boolean errorThrown = false;
        
        try
        {
            byte[] messageBytes = null;
            
            messageProperties = getMessageProperties(message);
            requestId = messageProperties.get( REQUEST_ID );
            templateId = messageProperties.get(TEMPLATE_ID);
            uId =  messageProperties.get(UNIQUE_ID);
            		
            if ( message instanceof BytesMessage )
            {
                BytesMessage bytesMsg = ( BytesMessage )message;
                int msgLength = ( int )bytesMsg.getBodyLength();
                messageBytes = new byte[msgLength];
                bytesMsg.readBytes( messageBytes );
            }
            else if ( message instanceof TextMessage )
            {
                TextMessage textMsg = ( TextMessage )message;
                messageBytes = textMsg.getText().getBytes();
            }

            ByteBuffer messageBuffer = ByteBuffer.wrap( messageBytes );
            String jsonPayload = new String( messageBuffer.array() );

            String document = constructXmlMessagePayload(jsonPayload, messageProperties);
            response = doClinicalOperation( document, templateId, requestId );

        }
        catch ( Exception e )
        {
            errorThrown = true;
        	String msg = "Exception occured while processing FPDS write request message.";
            logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, requestId, fpdsAppName, msg ), e );
            
            if(response == null)
            {
                templateId = (templateId != null) ? templateId : "CdsResponse400";
                requestId = (requestId != null) ? requestId : NO_REQUEST_ID_PROVIDED;
                response = clinicalDataResponse.buildEmptyClinicalDocument( templateId, requestId ).asXML();
            }
            
            throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, e, msg );
        }
        finally {
            try {
                
            	final String responseMessage = transfromXmlMessageResponseToJson(response, messageProperties, errorThrown);
                final String responseTemplateId = templateId;
                final String responseRequestId = requestId;
                final String responseUid = uId;
                
                // if there has been a 'Reply-To' queue associated with this request,
                // use it to supply the response.
                Destination destination = message.getJMSReplyTo();
                if( destination == null )
                {
                    // if no 'Reply-To' destination is supplied, use the default destination.
                    destination = responseJmsTemplate.getDefaultDestination();
                }
                
                if( responseMessage != null ) 
                {
                	
                    responseJmsTemplate.send(destination,  new MessageCreator()
                    {
                    	
                        @Override
                        public Message createMessage( Session session )
                            throws JMSException
                        {
                        	Message message = session.createTextMessage( responseMessage );
                            message.setStringProperty( TEMPLATE_ID, responseTemplateId );
                            message.setStringProperty( REQUEST_ID, responseRequestId );
                            message.setStringProperty( UNIQUE_ID, responseUid );
                            return message;
                        }
                    });
                }
            } catch (Exception ex2) {
                String errMsg = "Failed to publish response message to JMS destination.";
                logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, requestId, fpdsAppName, errMsg ), ex2 );
                
                throw new RuntimeMDBOnMessageException( ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, ex2, errMsg );
            }
        }
    }
    
    /**
     * Template method to override to invoke the appropriate CdS operation.
     * @param vhimPayload The VHIM template XML.
     * @param templateId The ID of the template.
     * @param requestId The request identifier.
     * @return The response XML template.
     */
    protected abstract String doClinicalOperation(String vhimPayload, String templateId, String requestId);
    
    protected abstract Map<String, String> getMessageProperties(Message message) throws JMSException;
    
    protected abstract String constructXmlMessagePayload(String messagePayload, Map<String,String> messageProperties);
    
    protected abstract String transfromXmlMessageResponseToJson(String xmlMessageResponse, Map<String,String> messageProperties, boolean errorThrown) throws TransformerConfigurationException, TransformerException, FileNotFoundException;
    
   /* public void setPersistOriginalMessage( Boolean persistOriginalMessage )
    {
        this.persistOriginalMessage = persistOriginalMessage;
    }
*/

    public void setCdsService( ClinicalDataServiceInterface cdsService )
    {
        this.cdsService = cdsService;
    }


    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }

      
    public void setClinicalDataResponse( ClinicalDataResponseInterface clinicalDataResponse )
    {
        this.clinicalDataResponse = clinicalDataResponse;
    }
    
    public void setResponseJmsTemplate( JmsTemplate responseJmsTemplate )
    {
        this.responseJmsTemplate = responseJmsTemplate;
    }
    
    protected boolean checkForErrors(String response){
    	boolean hasErrors = false;
    	try{
    		responseErrorSectionExtractor.checkForErrorsInResponse(response);
    	}
    	catch(Exception re){
    		hasErrors = true;
    	}
    	return hasErrors;
    }
    
}


