

package gov.va.med.cds.xml.transform;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.xml.transform.XsltTransformationException;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class XsltTransformationExceptionTest
{

    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void testXsltTransException( )
    {
        throw new XsltTransformationException( ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION );
    }


    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void testXsltTransExceptionCustomMessage( )
    {
        throw new XsltTransformationException( ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION, "Missing CVC value" );
    }


    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void testXsltTransExceptionWithCause( )
    {
        throw new XsltTransformationException( ErrorCodeEnum.XSLT_HELPER_TRANSLATION_EXCEPTION, new Throwable( "Missing Xslt Exception" ) );
    }
}
