

package gov.va.med.cds.util;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;


/*
 * Tests xml to string conversion
 */
@RunWith( SuiteAwareRunner.class )
public class XmlStringOperationsTest
{
    XmlStringOperations xmlStringOperations = new XmlStringOperations();


    /*
     * Converts a xml to a string and saves it as a file on the disk.
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testXmlToString( )
        throws IOException
    {

        assertNotNull( xmlStringOperations.xmlToString( "src/test/java/gov/va/med/cds/util/TestData.xml" ) );

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testXmlStringToXmlFile( )
    {
        String xml = "<test></test>";
        String operation = "Test";
        Calendar testDateAndTime = new GregorianCalendar();
        String outputFile = "./target/" + operation + "Output " + ( testDateAndTime.get( Calendar.MONTH ) + 1 ) + "-"
                        + testDateAndTime.get( Calendar.DATE ) + "-" + testDateAndTime.get( Calendar.YEAR ) + " "
                        + testDateAndTime.get( Calendar.HOUR_OF_DAY ) + "-" + testDateAndTime.get( Calendar.MINUTE ) + "-"
                        + testDateAndTime.get( Calendar.SECOND ) + ".xml";

        assertNotNull( xmlStringOperations.xmlStringToXmlFile( xml, operation, outputFile ) );

        xmlStringOperations.xmlStringToXmlFile( xml, operation, "./ouput/testFile.txt" );

        xml = "<test>";
        xmlStringOperations.xmlStringToXmlFile( xml, operation, outputFile );

        //delete created test output file
        new File( outputFile ).delete();
    }
}
