

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class StringUtilTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testStringArrayConcat( )
    {
        final String[] a = new String[] { "abc", "def" };
        final String[] b = new String[] { "ghi", "jkl" };

        String[] concatted = StringUtil.concat( a, b );
        assertEquals( concatted[0], "abc" );
        assertEquals( concatted[1], "def" );
        assertEquals( concatted[2], "ghi" );
        assertEquals( concatted[3], "jkl" );

        concatted = StringUtil.concat( null, b );
        assertEquals( concatted[0], "ghi" );
        assertEquals( concatted[1], "jkl" );

        concatted = StringUtil.concat( a, null );
        assertEquals( concatted[0], "abc" );
        assertEquals( concatted[1], "def" );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testStripNewlines( )
    {
        String source = "abc\ndef\nxyz";
        String expectedResult = "abcdefxyz";

        String result = StringUtil.stripNewlines( source );
        assertEquals( result, expectedResult );

        assertNull( StringUtil.stripNewlines( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetLastStringAfterTheDelimiter( )
    {
        String source = "abc#def#xyz";
        char searchDelimiter = '#';
        String expectedResult = "xyz";

        String result = StringUtil.getLastStringAfterTheDelimiter( source, searchDelimiter );
        assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsIgnoreWhiteSpace( )
    {
        String string1 = "abcdef";
        String string2 = "abc de f";

        boolean result = StringUtil.equalsIgnoreWhiteSpace( string1, string2 );
        assertTrue( result );

        assertTrue( StringUtil.equalsIgnoreWhiteSpace( "a   bc", "abc" ) );
        assertFalse( StringUtil.equalsIgnoreWhiteSpace( "abc", "def" ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSplitAndSortsubStrings( )
    {
        String source = "def:abc:xyz:ghi";
        String expectedResult = "abc:def:ghi:xyz";

        String result = StringUtil.splitAndSortsubStrings( source, ":" );
        assertEquals( result, expectedResult );

        source = "def:c#ab:y#z#x:ghi";
        expectedResult = "ab#c:def:ghi:x#y#z";

        result = StringUtil.splitAndSortsubStrings( source, ":", "#" );
        assertEquals( result, expectedResult );
    }
}
