

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.TimeZone;


@RunWith( SuiteAwareRunner.class )
public class DateTimeUtilTest
{
    long milliSeconds = 1000000000000L; // Sat Sep 09 01:46:40 GMT 2001
    TimeZone timeZone = TimeZone.getTimeZone( "GMT+0000" ); //.getID();


    @Test
    @Suite( groups = "checkintest" )
    public void testGetISOTime( )
    {
        String isoTime = DateTimeUtil.getISOTime( milliSeconds, timeZone );
        assertEquals( "20010909014640.000+0000", isoTime );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPartialISOTime( )
    {
        String partialIsoTime = DateTimeUtil.getPartialISOTime( milliSeconds, null );

        partialIsoTime = DateTimeUtil.getPartialISOTime( milliSeconds, timeZone );
        assertEquals( "20019090146", partialIsoTime ); //yyyMddHHmm
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetDateTimeDotSeparated( )
    {
        String partialIsoTime = DateTimeUtil.getDateTimeDotSeparated( milliSeconds, timeZone );
        assertEquals( "20010909.014640", partialIsoTime ); //yyyyMMdd.HHmmss
    }
}
