

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.VdmMarshallerMethodMetrics;

import org.junit.Test;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class VdmMarshallerMethodMetricsTest
{
    VdmMarshallerMethodMetrics vdmMarshallerMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        vdmMarshallerMethodMetrics = new VdmMarshallerMethodMetrics();
        vdmMarshallerMethodMetrics.enableMetrics();

        assertTrue( vdmMarshallerMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmMarshallerMethodMetrics.getVdmMarshallerTransactions() );
        assertEquals( methodElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerElapsedTime() );
        assertEquals( transactionsPerSecond, vdmMarshallerMethodMetrics.getVdmMarshallerTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        vdmMarshallerMethodMetrics = new VdmMarshallerMethodMetrics();
        vdmMarshallerMethodMetrics.enableMetrics();
        vdmMarshallerMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( vdmMarshallerMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmMarshallerMethodMetrics.getVdmMarshallerTransactions() );
        assertEquals( methodElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerElapsedTime() );
        assertEquals( transactionsPerSecond, vdmMarshallerMethodMetrics.getVdmMarshallerTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        vdmMarshallerMethodMetrics = new VdmMarshallerMethodMetrics();
        vdmMarshallerMethodMetrics.enableMetrics();

        assertTrue( vdmMarshallerMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmMarshallerMethodMetrics.getVdmMarshallerTransactions() );
        assertEquals( methodElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerElapsedTime() );
        assertEquals( transactionsPerSecond, vdmMarshallerMethodMetrics.getVdmMarshallerTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMinElapsedTime() );

        vdmMarshallerMethodMetrics.disableMetrics();
        assertFalse( vdmMarshallerMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, vdmMarshallerMethodMetrics.getVdmMarshallerTransactions() );
        assertEquals( methodElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerElapsedTime() );
        assertEquals( transactionsPerSecond, vdmMarshallerMethodMetrics.getVdmMarshallerTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMaxElapsedTime() );
        assertEquals( minElapsedTime, vdmMarshallerMethodMetrics.getVdmMarshallerMinElapsedTime() );
    }
}
