

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.TransMgrReadMethodMetrics;

import org.junit.Test;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class TransMgrReadMethodMetricsTest
{
    private TransMgrReadMethodMetrics transMgrReadMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        transMgrReadMethodMetrics = new TransMgrReadMethodMetrics();
        transMgrReadMethodMetrics.enableMetrics();

        assertTrue( transMgrReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, transMgrReadMethodMetrics.getTransMgrReadTransactions() );
        assertEquals( methodElapsedTime, transMgrReadMethodMetrics.getTransMgrReadElapsedTime() );
        assertEquals( transactionsPerSecond, transMgrReadMethodMetrics.getTransMgrReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, transMgrReadMethodMetrics.getTransMgrReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMaxElapsedTime() );
        assertEquals( minElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        transMgrReadMethodMetrics = new TransMgrReadMethodMetrics();
        transMgrReadMethodMetrics.enableMetrics();
        transMgrReadMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( transMgrReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, transMgrReadMethodMetrics.getTransMgrReadTransactions() );
        assertEquals( methodElapsedTime, transMgrReadMethodMetrics.getTransMgrReadElapsedTime() );
        assertEquals( transactionsPerSecond, transMgrReadMethodMetrics.getTransMgrReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, transMgrReadMethodMetrics.getTransMgrReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMaxElapsedTime() );
        assertEquals( minElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        transMgrReadMethodMetrics = new TransMgrReadMethodMetrics();
        transMgrReadMethodMetrics.enableMetrics();

        assertTrue( transMgrReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, transMgrReadMethodMetrics.getTransMgrReadTransactions() );
        assertEquals( methodElapsedTime, transMgrReadMethodMetrics.getTransMgrReadElapsedTime() );
        assertEquals( transactionsPerSecond, transMgrReadMethodMetrics.getTransMgrReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, transMgrReadMethodMetrics.getTransMgrReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMaxElapsedTime() );
        assertEquals( minElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMinElapsedTime() );

        transMgrReadMethodMetrics.disableMetrics();
        assertFalse( transMgrReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, transMgrReadMethodMetrics.getTransMgrReadTransactions() );
        assertEquals( methodElapsedTime, transMgrReadMethodMetrics.getTransMgrReadElapsedTime() );
        assertEquals( transactionsPerSecond, transMgrReadMethodMetrics.getTransMgrReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, transMgrReadMethodMetrics.getTransMgrReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMaxElapsedTime() );
        assertEquals( minElapsedTime, transMgrReadMethodMetrics.getTransMgrReadMinElapsedTime() );
    }
}
