

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.Arrays;
import java.util.List;

import org.junit.runner.RunWith;
import org.junit.Test;

@RunWith(SuiteAwareRunner.class)
public class MetricsCalculatorTest
{
    @Test
    @Suite( groups = "checkintest" )
    @SuppressWarnings( "unchecked" )
    public void testCalcMedian( )
    {
        // Median of 1, 5, 2, 8, 7 is 7
        Long[] longArray = new Long[] { 1L, 5L, 2L, 8L, 7L };
        List<Long> measurements = Arrays.asList( longArray );

        assertEquals( 7.0d, MetricsCalculator.calcMedian( measurements ), 0.0 );

        // Median of 1, 5, 2, 10, 8, 7 is 6
        longArray = new Long[] { 1L, 5L, 2L, 10L, 8L, 7L };
        measurements = Arrays.asList( longArray );

        assertEquals( 6.0d, MetricsCalculator.calcMedian( measurements ), 0.0 );

        // Median of 5 is 5
        longArray = new Long[] { 5L };
        measurements = Arrays.asList( longArray );

        assertEquals( 5.0d, MetricsCalculator.calcMedian( measurements ), 0.0 );

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testCalcStandardDeviation( )
    {
        // standard deviation of the set {3, 7, 7, 19} is 6
        Long[] longArray = new Long[] { 3L, 7L, 7L, 19L };
        List<Long> measurements = Arrays.asList( longArray );

        assertEquals( 6.0d, MetricsCalculator.calcStandardDeviation( measurements, measurements.size(), calculateMean( measurements ) ), 0.0 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetTransactionsPerSecond( )
    {
        long count = 500L;
        long elapsedTime = 10L;
        double expectedTransactionsPerSecond = 00000.0d;
        assertEquals( expectedTransactionsPerSecond, MetricsCalculator.getTransactionsPerSecond( count, elapsedTime ), 0.0 );
    }


    private double calculateMean( List<Long> measurements )
    {
        long sum = 0;
        double mean = 0.0d;
        for ( Long measurement : measurements )
        {
            sum += measurement;
        }
        mean = sum / measurements.size();
        return mean;
    }
}
