

package gov.va.med.cds.common.person.correlation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class PersonIdentifierTest
{
    String identity = "identity";
    String assigningFacility = "assigningFacility";
    String assigningAuthority = "assigningAuthority";
    PersonIdentifier personIdentifier;


    @Test
    @Suite( groups = "checkintest" )
    public void testPersonIdentifierSettersAndGetters( )
    {
        personIdentifier = new PersonIdentifier();

        personIdentifier.setIdentity( identity );
        personIdentifier.setAssigningFacility( assigningFacility );
        personIdentifier.setAssigningAuthority( assigningAuthority );

        assertEquals( personIdentifier.getIdentity(), identity );
        assertEquals( personIdentifier.getAssigningFacility(), assigningFacility );
        assertEquals( personIdentifier.getAssigningAuthority(), assigningAuthority );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testComparePersonIdentifierObject( )
    {
        PersonIdentifier personIdentifier1 = new PersonIdentifier();
        PersonIdentifier personIdentifier2 = new PersonIdentifier();

        personIdentifier1.setIdentity( identity );
        personIdentifier1.setAssigningFacility( assigningFacility );
        personIdentifier1.setAssigningAuthority( assigningAuthority );

        personIdentifier2.setIdentity( identity );
        personIdentifier2.setAssigningFacility( assigningFacility );
        personIdentifier2.setAssigningAuthority( assigningAuthority );

        assertFalse( personIdentifier1.equals( null ) );
        assertTrue( personIdentifier1.equals( personIdentifier2 ) );
        assertTrue( personIdentifier1.hashCode() == personIdentifier2.hashCode() );
    }
}
